/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeListJoin;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.expression.function.IndexFunction;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.AbstractPluralAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import com.blazebit.persistence.criteria.impl.support.ListJoinSupport;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import java.util.List;

public class ListAttributeJoin<O, E>
extends AbstractPluralAttributeJoin<O, List<E>, E>
implements BlazeListJoin<O, E>,
ListJoinSupport<O, E> {
    private static final long serialVersionUID = 1L;

    private ListAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, ListAttributeJoin<O, ? super E> original, EntityType<E> treatType) {
        super(criteriaBuilder, original, treatType);
    }

    public ListAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, Class<E> javaType, AbstractPath<O> pathSource, ListAttribute<? super O, E> joinAttribute, JoinType joinType) {
        super(criteriaBuilder, javaType, pathSource, joinAttribute, joinType);
    }

    public Expression<Integer> index() {
        return new IndexFunction(this.criteriaBuilder, this);
    }

    @Override
    public ListAttribute<? super O, E> getAttribute() {
        return (ListAttribute)super.getAttribute();
    }

    public ListAttribute<? super O, E> getModel() {
        return this.getAttribute();
    }

    @Override
    public final ListAttributeJoin<O, E> correlateTo(SubqueryExpression<?> subquery) {
        return (ListAttributeJoin)super.correlateTo((SubqueryExpression)subquery);
    }

    @Override
    protected AbstractFrom<O, E> createCorrelationDelegate() {
        return new ListAttributeJoin(this.criteriaBuilder, this.getJavaType(), this.getParentPath(), this.getAttribute(), this.getJoinType());
    }

    @Override
    public ListAttributeJoin<O, E> on(Expression<Boolean> restriction) {
        super.onExpression(restriction);
        return this;
    }

    @Override
    public ListAttributeJoin<O, E> on(Predicate ... restrictions) {
        super.onPredicates(restrictions);
        return this;
    }

    @Override
    public <T extends E> ListAttributeJoin<O, T> treatJoin(Class<T> treatType) {
        this.setTreatType(treatType);
        return this;
    }

    @Override
    public <T extends E> ListAttributeJoin<O, T> treatAs(Class<T> treatAsType) {
        if (treatAsType.isAssignableFrom(this.getJavaType())) {
            return this;
        }
        return this.addTreatedPath(new TreatedListAttributeJoin(this.criteriaBuilder, this, this.getTreatType(treatAsType)));
    }

    public static class TreatedListAttributeJoin<O, E>
    extends ListAttributeJoin<O, E>
    implements TreatedPath<E> {
        private static final long serialVersionUID = 1L;
        private final ListAttributeJoin<?, ? super E> treatedJoin;
        private final EntityType<E> treatType;

        public TreatedListAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, ListAttributeJoin<O, ? super E> treatedJoin, EntityType<E> treatType) {
            super(criteriaBuilder, treatedJoin, treatType);
            this.treatedJoin = treatedJoin;
            this.treatType = treatType;
        }

        @Override
        protected ManagedType<E> getManagedType() {
            return this.treatType;
        }

        @Override
        public EntityType<E> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super E> getTreatedPath() {
            return this.treatedJoin;
        }

        @Override
        public String getAlias() {
            return this.treatedJoin.getAlias();
        }

        @Override
        public String getPathExpression() {
            return this.getAlias();
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(").append(this.resolveAlias(context)).append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

