/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeSetJoin;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.AbstractPluralAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import com.blazebit.persistence.criteria.impl.support.SetJoinSupport;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SetAttribute;
import java.util.Set;

public class SetAttributeJoin<O, E>
extends AbstractPluralAttributeJoin<O, Set<E>, E>
implements BlazeSetJoin<O, E>,
SetJoinSupport<O, E> {
    private static final long serialVersionUID = 1L;

    private SetAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, SetAttributeJoin<O, ? super E> original, EntityType<E> treatType) {
        super(criteriaBuilder, original, treatType);
    }

    public SetAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, Class<E> javaType, AbstractPath<O> pathSource, SetAttribute<? super O, E> joinAttribute, JoinType joinType) {
        super(criteriaBuilder, javaType, pathSource, joinAttribute, joinType);
    }

    @Override
    public SetAttribute<? super O, E> getAttribute() {
        return (SetAttribute)super.getAttribute();
    }

    public SetAttribute<? super O, E> getModel() {
        return this.getAttribute();
    }

    @Override
    public final SetAttributeJoin<O, E> correlateTo(SubqueryExpression<?> subquery) {
        return (SetAttributeJoin)super.correlateTo((SubqueryExpression)subquery);
    }

    @Override
    protected AbstractFrom<O, E> createCorrelationDelegate() {
        return new SetAttributeJoin(this.criteriaBuilder, this.getJavaType(), this.getParentPath(), this.getAttribute(), this.getJoinType());
    }

    @Override
    public SetAttributeJoin<O, E> on(Expression<Boolean> restriction) {
        super.onExpression(restriction);
        return this;
    }

    @Override
    public SetAttributeJoin<O, E> on(Predicate ... restrictions) {
        super.onPredicates(restrictions);
        return this;
    }

    @Override
    public <T extends E> SetAttributeJoin<O, T> treatJoin(Class<T> treatType) {
        this.setTreatType(treatType);
        return this;
    }

    @Override
    public <T extends E> SetAttributeJoin<O, T> treatAs(Class<T> treatAsType) {
        if (treatAsType.isAssignableFrom(this.getJavaType())) {
            return this;
        }
        return this.addTreatedPath(new TreatedSetAttributeJoin(this.criteriaBuilder, this, this.getTreatType(treatAsType)));
    }

    public static class TreatedSetAttributeJoin<O, E>
    extends SetAttributeJoin<O, E>
    implements TreatedPath<E> {
        private static final long serialVersionUID = 1L;
        private final SetAttributeJoin<?, ? super E> treatedJoin;
        private final EntityType<E> treatType;

        public TreatedSetAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, SetAttributeJoin<O, ? super E> treatedJoin, EntityType<E> treatType) {
            super(criteriaBuilder, treatedJoin, treatType);
            this.treatedJoin = treatedJoin;
            this.treatType = treatType;
        }

        @Override
        protected ManagedType<E> getManagedType() {
            return this.treatType;
        }

        @Override
        public EntityType<E> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super E> getTreatedPath() {
            return this.treatedJoin;
        }

        @Override
        public String getAlias() {
            return this.treatedJoin.getAlias();
        }

        @Override
        public String getPathExpression() {
            return this.getAlias();
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(").append(this.resolveAlias(context)).append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

