/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractJoin;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;

public class SingularAttributeJoin<Z, X>
extends AbstractJoin<Z, X> {
    private static final long serialVersionUID = 1L;
    private final Bindable<X> model;

    private SingularAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, SingularAttributeJoin<Z, ? super X> original, EntityType<X> treatType) {
        super(criteriaBuilder, original, treatType);
        this.model = treatType;
    }

    public SingularAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType, AbstractPath<Z> pathSource, SingularAttribute<? super Z, ?> joinAttribute, JoinType joinType) {
        super(criteriaBuilder, javaType, pathSource, joinAttribute, joinType);
        this.model = (Bindable)(Attribute.PersistentAttributeType.EMBEDDED == joinAttribute.getPersistentAttributeType() ? joinAttribute : criteriaBuilder.getEntityMetamodel().managedType(javaType));
    }

    @Override
    public SingularAttribute<? super Z, ?> getAttribute() {
        return (SingularAttribute)super.getAttribute();
    }

    @Override
    public SingularAttributeJoin<Z, X> correlateTo(SubqueryExpression<?> subquery) {
        return (SingularAttributeJoin)super.correlateTo((SubqueryExpression)subquery);
    }

    @Override
    protected AbstractFrom<Z, X> createCorrelationDelegate() {
        return new SingularAttributeJoin(this.criteriaBuilder, this.getJavaType(), this.getBasePath(), this.getAttribute(), this.getJoinType());
    }

    @Override
    protected boolean isJoinAllowed() {
        return true;
    }

    @Override
    protected ManagedType<? super X> getManagedType() {
        Bindable<X> m = this.getModel();
        Bindable.BindableType t = m.getBindableType();
        switch (t) {
            case ENTITY_TYPE: {
                return (ManagedType)m;
            }
            case SINGULAR_ATTRIBUTE: {
                Type joinedAttributeType = this.getAttribute().getType();
                if (!(joinedAttributeType instanceof ManagedType)) {
                    throw new IllegalArgumentException("Joins on '" + this.getPathExpression() + "' are not allowed");
                }
                return (ManagedType)joinedAttributeType;
            }
            case PLURAL_ATTRIBUTE: {
                Type elementType = ((PluralAttribute)this.getAttribute()).getElementType();
                if (!(elementType instanceof ManagedType)) {
                    throw new IllegalArgumentException("Joins on '" + this.getPathExpression() + "' are not allowed");
                }
                return (ManagedType)elementType;
            }
        }
        return super.getManagedType();
    }

    public Bindable<X> getModel() {
        if (this.treatJoinType != null) {
            return this.treatJoinType;
        }
        return this.model;
    }

    @Override
    public SingularAttributeJoin<Z, X> on(Expression<Boolean> restriction) {
        super.onExpression(restriction);
        return this;
    }

    @Override
    public SingularAttributeJoin<Z, X> on(Predicate ... restrictions) {
        super.onPredicates(restrictions);
        return this;
    }

    @Override
    public <T extends X> SingularAttributeJoin<Z, T> treatJoin(Class<T> treatType) {
        this.setTreatType(treatType);
        return this;
    }

    @Override
    public <T extends X> SingularAttributeJoin<Z, T> treatAs(Class<T> treatAsType) {
        if (treatAsType.isAssignableFrom(this.getJavaType())) {
            return this;
        }
        return this.addTreatedPath(new TreatedSingularAttributeJoin(this.criteriaBuilder, this, this.getTreatType(treatAsType)));
    }

    public static class TreatedSingularAttributeJoin<Z, X>
    extends SingularAttributeJoin<Z, X>
    implements TreatedPath<X> {
        private static final long serialVersionUID = 1L;
        private final SingularAttributeJoin<?, ? super X> treatedJoin;
        private final EntityType<X> treatType;

        public TreatedSingularAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, SingularAttributeJoin<Z, ? super X> treatedJoin, EntityType<X> treatType) {
            super(criteriaBuilder, treatedJoin, treatType);
            this.treatedJoin = treatedJoin;
            this.treatType = treatType;
        }

        @Override
        protected ManagedType<X> getManagedType() {
            return this.treatType;
        }

        @Override
        public EntityType<X> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super X> getTreatedPath() {
            return this.treatedJoin;
        }

        @Override
        public String getAlias() {
            return this.treatedJoin.getAlias();
        }

        @Override
        public String getPathExpression() {
            return this.getAlias();
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            this.resolveAlias(context);
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(").append(this.getAlias()).append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

