/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;

public class SingularAttributePath<X>
extends AbstractPath<X> {
    private static final long serialVersionUID = 1L;
    private final SingularAttribute<?, X> attribute;
    private final ManagedType<X> managedType;

    private SingularAttributePath(BlazeCriteriaBuilderImpl criteriaBuilder, SingularAttributePath<? super X> original, EntityType<X> treatType) {
        super(criteriaBuilder, treatType.getJavaType(), original.getBasePath());
        this.attribute = original.getAttribute();
        this.managedType = treatType;
    }

    public SingularAttributePath(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType, AbstractPath<?> pathSource, SingularAttribute<?, X> attribute) {
        super(criteriaBuilder, javaType, pathSource);
        this.attribute = attribute;
        this.managedType = this.getManagedType(attribute);
    }

    private SingularAttributePath(SingularAttributePath<X> origin, String alias) {
        super(origin.criteriaBuilder, origin.getJavaType(), origin.getBasePath());
        this.attribute = origin.attribute;
        this.managedType = origin.managedType;
        this.setAlias(alias);
    }

    @Override
    public Selection<X> alias(String alias) {
        return new SingularAttributePath<X>(this, alias);
    }

    private ManagedType<X> getManagedType(SingularAttribute<?, X> attribute) {
        if (Attribute.PersistentAttributeType.BASIC == attribute.getPersistentAttributeType()) {
            return null;
        }
        if (Attribute.PersistentAttributeType.EMBEDDED == attribute.getPersistentAttributeType()) {
            return (EmbeddableType)attribute.getType();
        }
        return (IdentifiableType)attribute.getType();
    }

    @Override
    public SingularAttribute<?, X> getAttribute() {
        return this.attribute;
    }

    public Bindable<X> getModel() {
        return this.getAttribute();
    }

    @Override
    protected boolean isDereferencable() {
        return this.managedType != null;
    }

    @Override
    protected Attribute<?, ?> findAttribute(String attributeName) {
        Attribute attribute = this.managedType.getAttribute(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException("Could not resolve attribute named: " + attributeName);
        }
        return attribute;
    }

    @Override
    public <T extends X> SingularAttributePath<T> treatAs(Class<T> treatAsType) {
        return new TreatedSingularAttributePath<T>(this.criteriaBuilder, this, this.getTreatType(treatAsType));
    }

    public static class TreatedSingularAttributePath<T>
    extends SingularAttributePath<T>
    implements TreatedPath<T> {
        private static final long serialVersionUID = 1L;
        private final SingularAttributePath<? super T> treatedPath;
        private final EntityType<T> treatType;

        public TreatedSingularAttributePath(BlazeCriteriaBuilderImpl criteriaBuilder, SingularAttributePath<? super T> treatedPath, EntityType<T> treatType) {
            super(criteriaBuilder, treatedPath, treatType);
            this.treatedPath = treatedPath;
            this.treatType = treatType;
        }

        @Override
        public EntityType<T> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super T> getTreatedPath() {
            return this.treatedPath;
        }

        @Override
        public String getAlias() {
            return this.treatedPath.getAlias();
        }

        @Override
        public String getPathExpression() {
            return "TREAT(" + this.treatedPath.getPathExpression() + " AS " + this.getTreatType().getName() + ')';
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(");
            this.treatedPath.renderPathExpression(context);
            buffer.append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

