/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter;

import com.blazemeter.jmeter.DirectoryListingIterator;
import java.io.File;
import java.io.Serializable;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.util.JMeterStopThreadException;

public class DirectoryListingConfig
extends ConfigTestElement
implements NoThreadClone,
LoopIterationListener,
TestStateListener {
    public static final String DEFAULT_DESTINATION_VARIABLE_NAME = "filename";
    public static final String DEFAULT_SOURCE_DIRECTORY = ".";
    private final ThreadLocal<DirectoryListingIterator> threadLocalIterator = new ThreadLocalSerializable<DirectoryListingIterator>(){

        @Override
        protected DirectoryListingIterator initialValue() {
            return DirectoryListingConfig.this.createDirectoryListingIterator();
        }
    };
    public static final String SOURCE_DIRECTORY = "directory";
    public static final String DESTINATION_VARIABLE_NAME = "variableName";
    public static final String USE_FULL_PATH = "useFullPath";
    public static final String RANDOM_ORDER = "randomOrder";
    public static final String RECURSIVE_LISTING = "recursiveListing";
    public static final String REWIND_ON_THE_END = "rewindOnTheEndOfList";
    public static final String INDEPENDENT_LIST_PER_THREAD = "independentListPerThread";
    public static final String RE_READ_DIRECTORY_ON_THE_END_OF_LIST = "reReadDirectory";
    private DirectoryListingIterator directoryListingIterator;

    public void iterationStart(LoopIterationEvent loopIterationEvent) {
        boolean isIndependentListPerThread = this.getIndependentListPerThread();
        if (!isIndependentListPerThread && this.directoryListingIterator == null) {
            throw new JMeterStopThreadException("All files in the directory have been passed.");
        }
        if (!this.getIterator().hasNext()) {
            this.directoryListingIterator = null;
            throw new JMeterStopThreadException("All files in the directory have been passed.");
        }
        JMeterVariables variables = JMeterContextService.getContext().getVariables();
        variables.put(DirectoryListingConfig.getStringOrDefault(this.getDestinationVariableName(), DEFAULT_DESTINATION_VARIABLE_NAME), this.getFilePath(this.getIterator().next()));
    }

    private DirectoryListingIterator getIterator() {
        return this.getIndependentListPerThread() ? this.threadLocalIterator.get() : this.directoryListingIterator;
    }

    protected String getFilePath(File file) {
        return this.getUseFullPath() ? file.getAbsolutePath() : this.getSubPath(file.getAbsolutePath());
    }

    private String getSubPath(String absolutePath) {
        String rootDir = this.getSourceDirectory();
        File sourceDir = new File(rootDir);
        return sourceDir.isAbsolute() ? absolutePath.substring(rootDir.length()) : absolutePath.substring(sourceDir.getAbsolutePath().length());
    }

    public DirectoryListingIterator createDirectoryListingIterator() {
        return new DirectoryListingIterator(DirectoryListingConfig.getStringOrDefault(this.getSourceDirectory(), DEFAULT_SOURCE_DIRECTORY), this.getRandomOrder(), this.getRecursiveListing(), this.getRewindOnTheEnd(), this.getReReadDirectoryOnTheEndOfList());
    }

    public String getSourceDirectory() {
        return this.getPropertyAsString(SOURCE_DIRECTORY);
    }

    public String getDestinationVariableName() {
        return this.getPropertyAsString(DESTINATION_VARIABLE_NAME);
    }

    public static String getStringOrDefault(String str, String defaultValue) {
        return str == null || str.isEmpty() ? defaultValue : str;
    }

    public boolean getUseFullPath() {
        return this.getPropertyAsBoolean(USE_FULL_PATH);
    }

    public boolean getRandomOrder() {
        return this.getPropertyAsBoolean(RANDOM_ORDER);
    }

    public boolean getRecursiveListing() {
        return this.getPropertyAsBoolean(RECURSIVE_LISTING);
    }

    public boolean getRewindOnTheEnd() {
        return this.getPropertyAsBoolean(REWIND_ON_THE_END);
    }

    public boolean getIndependentListPerThread() {
        return this.getPropertyAsBoolean(INDEPENDENT_LIST_PER_THREAD);
    }

    public boolean getReReadDirectoryOnTheEndOfList() {
        return this.getPropertyAsBoolean(RE_READ_DIRECTORY_ON_THE_END_OF_LIST);
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.setProperty(SOURCE_DIRECTORY, sourceDirectory);
    }

    public void setDestinationVariableName(String destinationVariableName) {
        this.setProperty(DESTINATION_VARIABLE_NAME, destinationVariableName);
    }

    public void setUseFullPath(boolean useFullPath) {
        this.setProperty(USE_FULL_PATH, useFullPath);
    }

    public void setRandomOrder(boolean randomOrder) {
        this.setProperty(RANDOM_ORDER, randomOrder);
    }

    public void setRecursiveListing(boolean recursiveListing) {
        this.setProperty(RECURSIVE_LISTING, recursiveListing);
    }

    public void setRewindOnTheEnd(boolean rewindOnTheEnd) {
        this.setProperty(REWIND_ON_THE_END, rewindOnTheEnd);
    }

    public void setIndependentListPerThread(boolean independentListPerThread) {
        this.setProperty(INDEPENDENT_LIST_PER_THREAD, independentListPerThread);
    }

    public void setReReadDirectoryOnTheEndOfList(boolean reReadDirectoryOnTheEndOfList) {
        this.setProperty(RE_READ_DIRECTORY_ON_THE_END_OF_LIST, reReadDirectoryOnTheEndOfList);
    }

    public void testStarted() {
        this.testStarted("*local*");
    }

    public void testStarted(String s) {
        this.directoryListingIterator = this.createDirectoryListingIterator();
    }

    public void testEnded() {
        this.testEnded("*local*");
    }

    public void testEnded(String s) {
        this.directoryListingIterator = null;
    }

    private static class ThreadLocalSerializable<T>
    extends ThreadLocal<T>
    implements Serializable {
        private ThreadLocalSerializable() {
        }
    }
}

