/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter;

import com.blazemeter.jmeter.DirectoryListingConfig;
import com.blazemeter.jmeter.TestDirectoryListingAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.BrowseAction;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;

public class DirectoryListingConfigGui
extends AbstractConfigGui {
    public static final String WIKIPAGE = "DirectoryListing";
    private JTextField sourceDirectoryField;
    private JButton browseButton;
    private JTextField destinationVariableField;
    private JCheckBox isUseFullPathCheckBox;
    private JCheckBox isRecursiveListing;
    private JCheckBox isRandomOrderCheckBox;
    private JCheckBox isRewindOnTheEndCheckBox;
    private JCheckBox isIndependentListCheckBox;
    private JCheckBox isReReadDirectoryCheckBox;
    private JButton checkButton;
    private JTextArea checkArea;

    public DirectoryListingConfigGui() {
        this.initGui();
        this.initGuiValues();
    }

    private void initGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Container topPanel = this.makeTitlePanel();
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)topPanel, (String)WIKIPAGE), "North");
        this.add(topPanel, "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Source directory: ", 4));
        this.sourceDirectoryField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.sourceDirectoryField);
        this.browseButton = new JButton("Browse...");
        this.addToPanel(mainPanel, labelConstraints, 2, 0, this.browseButton);
        GuiBuilderHelper.strechItemToComponent((JComponent)this.sourceDirectoryField, (JComponent)this.browseButton);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.browseButton.addActionListener((ActionListener)new BrowseAction(this.sourceDirectoryField, true));
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Destination variable name: ", 4));
        this.destinationVariableField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.destinationVariableField);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Use full path: ", 4));
        this.isUseFullPathCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.isUseFullPathCheckBox);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Random order: ", 4));
        this.isRandomOrderCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.isRandomOrderCheckBox);
        this.addToPanel(mainPanel, labelConstraints, 0, 4, new JLabel("Recursive listing: ", 4));
        this.isRecursiveListing = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 4, this.isRecursiveListing);
        this.addToPanel(mainPanel, labelConstraints, 0, 5, new JLabel("Rewind on end of list: ", 4));
        this.isRewindOnTheEndCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 5, this.isRewindOnTheEndCheckBox);
        this.addToPanel(mainPanel, labelConstraints, 0, 6, new JLabel("Re-read directory on end of list: ", 4));
        this.isReReadDirectoryCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 6, this.isReReadDirectoryCheckBox);
        this.addToPanel(mainPanel, labelConstraints, 0, 7, new JLabel("Independent list per thread: ", 4));
        this.isIndependentListCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 7, this.isIndependentListCheckBox);
        this.isRewindOnTheEndCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryListingConfigGui.this.isReReadDirectoryCheckBox.setEnabled(DirectoryListingConfigGui.this.isRewindOnTheEndCheckBox.isSelected());
            }
        });
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 2);
        this.checkButton = new JButton("Test Directory Listing");
        this.addToPanel(mainPanel, labelConstraints, 0, 8, this.checkButton);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.checkArea = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 8, GuiBuilderHelper.getTextAreaScrollPaneContainer((JTextArea)this.checkArea, (int)10));
        this.checkButton.addActionListener(new TestDirectoryListingAction(this));
        this.checkArea.setEditable(false);
        this.checkArea.setOpaque(false);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void initGuiValues() {
        this.sourceDirectoryField.setText("");
        this.destinationVariableField.setText("");
        this.isUseFullPathCheckBox.setSelected(false);
        this.isRandomOrderCheckBox.setSelected(false);
        this.isRecursiveListing.setSelected(false);
        this.isRewindOnTheEndCheckBox.setSelected(true);
        this.isIndependentListCheckBox.setSelected(false);
        this.isReReadDirectoryCheckBox.setSelected(false);
        this.checkArea.setText("");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    public String getLabelResource() {
        return "directory_listing_data_source";
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Directory Listing Data Source");
    }

    public TestElement createTestElement() {
        DirectoryListingConfig element = new DirectoryListingConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof DirectoryListingConfig) {
            DirectoryListingConfig directoryListingConfig = (DirectoryListingConfig)element;
            directoryListingConfig.setSourceDirectory(this.sourceDirectoryField.getText());
            directoryListingConfig.setDestinationVariableName(this.destinationVariableField.getText());
            directoryListingConfig.setUseFullPath(this.isUseFullPathCheckBox.isSelected());
            directoryListingConfig.setRandomOrder(this.isRandomOrderCheckBox.isSelected());
            directoryListingConfig.setRecursiveListing(this.isRecursiveListing.isSelected());
            directoryListingConfig.setRewindOnTheEnd(this.isRewindOnTheEndCheckBox.isSelected());
            directoryListingConfig.setReReadDirectoryOnTheEndOfList(this.isReReadDirectoryCheckBox.isSelected());
            directoryListingConfig.setIndependentListPerThread(this.isIndependentListCheckBox.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof DirectoryListingConfig) {
            DirectoryListingConfig directoryListingConfig = (DirectoryListingConfig)element;
            this.sourceDirectoryField.setText(directoryListingConfig.getSourceDirectory());
            this.destinationVariableField.setText(directoryListingConfig.getDestinationVariableName());
            this.isUseFullPathCheckBox.setSelected(directoryListingConfig.getUseFullPath());
            this.isRandomOrderCheckBox.setSelected(directoryListingConfig.getRandomOrder());
            this.isRecursiveListing.setSelected(directoryListingConfig.getRecursiveListing());
            this.isRewindOnTheEndCheckBox.setSelected(directoryListingConfig.getRewindOnTheEnd());
            this.isReReadDirectoryCheckBox.setSelected(directoryListingConfig.getReReadDirectoryOnTheEndOfList());
            this.isIndependentListCheckBox.setSelected(directoryListingConfig.getIndependentListPerThread());
            this.isReReadDirectoryCheckBox.setEnabled(this.isRewindOnTheEndCheckBox.isSelected());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initGuiValues();
    }

    public JTextArea getCheckArea() {
        return this.checkArea;
    }
}

