/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class DirectoryListingIterator
implements Iterator<File> {
    private final String srcDir;
    private final boolean isRandomOrder;
    private final boolean isRecursiveListing;
    private final boolean isRewindOnEndOfList;
    private final boolean isReReadDirectory;
    private Iterator<File> iterator;
    private List<File> list;

    public DirectoryListingIterator(String srcDir, boolean isRandomOrder, boolean isRecursiveListing, boolean isRewindOnEndOfList, boolean isReReadDirectory) {
        this.srcDir = srcDir;
        this.isRandomOrder = isRandomOrder;
        this.isRecursiveListing = isRecursiveListing;
        this.isRewindOnEndOfList = isRewindOnEndOfList;
        this.isReReadDirectory = isReReadDirectory;
        this.list = this.getDirectoryListing();
        if (isRandomOrder) {
            DirectoryListingIterator.shuffleList(this.list);
        }
        this.iterator = this.list.iterator();
    }

    @Override
    public synchronized boolean hasNext() {
        if (!this.iterator.hasNext() && this.isRewindOnEndOfList) {
            if (this.isReReadDirectory) {
                this.list = this.getDirectoryListing();
            }
            if (this.isRandomOrder) {
                DirectoryListingIterator.shuffleList(this.list);
            }
            this.iterator = this.list.iterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public synchronized File next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing is not supported for this iterator");
    }

    protected List<File> getDirectoryListing() {
        try {
            return DirectoryListingIterator.getDirectoryListing(new File(this.srcDir), this.isRecursiveListing);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void shuffleList(List<File> list) {
        Collections.shuffle(list, new Random(System.currentTimeMillis()));
    }

    public static List<File> getDirectoryListing(File baseDir, boolean isRecursiveListing) throws FileNotFoundException {
        ArrayList<File> resultList = new ArrayList<File>();
        if (!baseDir.exists()) {
            throw new FileNotFoundException("Directory does not exists: " + baseDir.getAbsolutePath());
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return resultList;
        }
        for (File file : files) {
            boolean isDirectory = file.isDirectory();
            if (isRecursiveListing && isDirectory) {
                List<File> nestedListing = DirectoryListingIterator.getDirectoryListing(file, true);
                if (nestedListing.isEmpty()) continue;
                resultList.addAll(nestedListing);
                continue;
            }
            if (isDirectory) continue;
            resultList.add(file);
        }
        return resultList;
    }
}

