/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter;

import com.blazemeter.jmeter.DirectoryListingConfig;
import com.blazemeter.jmeter.DirectoryListingConfigGui;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JTextArea;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.util.JMeterStopThreadException;

public class TestDirectoryListingAction
implements ActionListener {
    private final DirectoryListingConfigGui directoryListingConfigGui;

    public TestDirectoryListingAction(DirectoryListingConfigGui fileListingGui) {
        this.directoryListingConfigGui = fileListingGui;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DirectoryListingConfig config = (DirectoryListingConfig)this.directoryListingConfigGui.createTestElement();
        config.setRewindOnTheEnd(false);
        config.setIndependentListPerThread(false);
        JTextArea checkArea = this.directoryListingConfigGui.getCheckArea();
        try {
            CompoundVariable compVarSrcDir = new CompoundVariable();
            compVarSrcDir.setParameters(config.getSourceDirectory());
            config.setSourceDirectory(compVarSrcDir.execute());
            CompoundVariable compVarDestVar = new CompoundVariable();
            compVarDestVar.setParameters(config.getDestinationVariableName());
            config.setDestinationVariableName(compVarDestVar.execute());
            String variableName = DirectoryListingConfig.getStringOrDefault(config.getDestinationVariableName(), "filename");
            JMeterVariables variables = new JMeterVariables();
            JMeterContextService.getContext().setVariables(variables);
            ArrayList<String> filePaths = new ArrayList<String>();
            config.testStarted();
            try {
                while (true) {
                    config.iterationStart(null);
                    filePaths.add(variables.get(variableName));
                }
            }
            catch (JMeterStopThreadException jMeterStopThreadException) {
                config.testEnded();
                StringBuilder builder = new StringBuilder();
                builder.append("Listing of directory successfully finished, ").append(filePaths.size()).append(" files found:\r\n");
                for (String filePath : filePaths) {
                    builder.append("${").append(variableName).append("} = ");
                    builder.append(filePath);
                    builder.append("\r\n");
                }
                checkArea.setText(builder.toString());
                checkArea.setCaretPosition(0);
            }
        }
        catch (RuntimeException | InvalidVariableException e) {
            checkArea.setText(e.getMessage());
        }
    }
}

