/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter;

import com.blazemeter.csv.RandomCSVReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class RandomCSVDataSetConfig
extends ConfigTestElement
implements NoThreadClone,
LoopIterationListener,
TestStateListener,
ThreadListener {
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    public static final String FILENAME = "filename";
    public static final String FILE_ENCODING = "fileEncoding";
    public static final String DELIMITED = "delimiter";
    public static final String VARIABLE_NAMES = "variableNames";
    public static final String RANDOM_ORDER = "randomOrder";
    public static final String IGNORE_FIRST_LINE = "ignoreFirstLine";
    public static final String REWIND_ON_THE_END = "rewindOnTheEndOfList";
    public static final String INDEPENDENT_LIST_PER_THREAD = "independentListPerThread";
    private final ThreadLocal<RandomCSVReader> threadLocalRandomCSVReader = new ThreadLocalSerializable<RandomCSVReader>(){

        @Override
        protected RandomCSVReader initialValue() {
            return null;
        }
    };
    private RandomCSVReader randomCSVReader = null;
    private RandomCSVReader initialCSVReader = null;
    private String filename;

    public void trySetFinalFilename() {
        if (this.filename == null) {
            this.filename = this.getFinalFilename();
            this.initialCSVReader = this.randomCSVReader = this.createRandomCSVReader();
        }
    }

    public void iterationStart(LoopIterationEvent loopIterationEvent) {
        boolean isIndependentListPerThread = this.isIndependentListPerThread();
        if (!isIndependentListPerThread && this.randomCSVReader == null) {
            throw new JMeterStopThreadException("All records in the CSV file have been passed.");
        }
        if (this.isRandomOrder()) {
            this.readRandom();
        } else {
            this.readConsistent();
        }
    }

    private String getFinalFilename() {
        String ret = this.getFilename();
        JMeterVariables variables = JMeterContextService.getContext().getVariables();
        Pattern pattern = Pattern.compile("\\$\\{([a-z]+)}");
        Matcher matcher = pattern.matcher(ret);
        while (matcher.find()) {
            String contents;
            try {
                contents = variables.get(matcher.group(1));
            }
            catch (NullPointerException e) {
                contents = null;
            }
            if (contents == null) continue;
            ret = ret.replace(matcher.group(), contents);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRandom() {
        long lineAddr;
        RandomCSVReader reader;
        RandomCSVReader randomCSVReader = reader = this.getReader();
        synchronized (randomCSVReader) {
            if (!reader.hasNextRecord()) {
                if (this.randomCSVReader != null) {
                    this.randomCSVReader.close();
                }
                this.randomCSVReader = null;
                throw new JMeterStopThreadException("All records in the CSV file have been passed.");
            }
            lineAddr = reader.getNextLineAddr();
        }
        JMeterVariables variables = JMeterContextService.getContext().getVariables();
        this.putVariables(variables, this.getDestinationVariableKeys(), reader.readLineWithSeek(lineAddr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConsistent() {
        RandomCSVReader reader;
        RandomCSVReader randomCSVReader = reader = this.getReader();
        synchronized (randomCSVReader) {
            if (!reader.hasNextRecord()) {
                if (this.randomCSVReader != null) {
                    try {
                        this.randomCSVReader.closeConsistentReader();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to close Consistent Reader", (Throwable)e);
                    }
                }
                this.randomCSVReader = null;
                throw new JMeterStopThreadException("All records in the CSV file have been passed.");
            }
            JMeterVariables variables = JMeterContextService.getContext().getVariables();
            this.putVariables(variables, this.getDestinationVariableKeys(), reader.readNextLine());
        }
    }

    public String[] getDestinationVariableKeys() {
        String vars = this.getVariableNames();
        return this.hasVariablesNames() ? JOrphanUtils.split((String)vars, (String)",") : this.getReader().getHeader();
    }

    private void putVariables(JMeterVariables variables, String[] keys, String[] values) {
        int minLen = Math.min(keys.length, values.length);
        for (int i = 0; i < minLen; ++i) {
            variables.put(keys[i], values[i]);
        }
    }

    private RandomCSVReader getReader() {
        return this.isIndependentListPerThread() ? this.threadLocalRandomCSVReader.get() : this.randomCSVReader;
    }

    private RandomCSVReader createRandomCSVReader() {
        return new RandomCSVReader(this.filename, this.getFileEncoding(), this.getDelimiter(), this.isRandomOrder(), this.hasVariablesNames(), this.isIgnoreFirstLine(), this.isRewindOnTheEndOfList());
    }

    private boolean hasVariablesNames() {
        String vars = this.getVariableNames();
        return vars != null && !vars.isEmpty();
    }

    public void threadStarted() {
        if (this.isIndependentListPerThread()) {
            this.threadLocalRandomCSVReader.set(this.initialCSVReader);
        }
    }

    public void threadFinished() {
        RandomCSVReader reader = this.getReader();
        if (reader != null) {
            reader.close();
            if (!this.isRandomOrder() && this.isIndependentListPerThread()) {
                try {
                    reader.closeConsistentReader();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close Consistent Reader", (Throwable)e);
                }
            }
        }
    }

    public void testStarted() {
        this.testStarted("*local*");
    }

    public void testStarted(String s) {
        this.trySetFinalFilename();
    }

    public void testEnded() {
        this.testEnded("*local*");
    }

    public void testEnded(String s) {
        try {
            if (this.randomCSVReader != null && !this.isRandomOrder()) {
                this.randomCSVReader.closeConsistentReader();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close Consistent Reader", (Throwable)e);
        }
        this.randomCSVReader = null;
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public void setFilename(String filename) {
        this.setProperty(FILENAME, filename);
    }

    public String getFileEncoding() {
        return this.getPropertyAsString(FILE_ENCODING);
    }

    public void setFileEncoding(String fileEncoding) {
        this.setProperty(FILE_ENCODING, fileEncoding);
    }

    public String getDelimiter() {
        return this.getPropertyAsString(DELIMITED);
    }

    public void setDelimiter(String delimiter) {
        this.setProperty(DELIMITED, delimiter);
    }

    public String getVariableNames() {
        return this.getPropertyAsString(VARIABLE_NAMES);
    }

    public void setVariableNames(String variableNames) {
        this.setProperty(VARIABLE_NAMES, variableNames);
    }

    public boolean isRandomOrder() {
        return this.getPropertyAsBoolean(RANDOM_ORDER);
    }

    public void setRandomOrder(boolean randomOrder) {
        this.setProperty(RANDOM_ORDER, randomOrder);
    }

    public boolean isIgnoreFirstLine() {
        return this.getPropertyAsBoolean(IGNORE_FIRST_LINE);
    }

    public void setIgnoreFirstLine(boolean ignoreFirstLine) {
        this.setProperty(IGNORE_FIRST_LINE, ignoreFirstLine);
    }

    public boolean isRewindOnTheEndOfList() {
        return this.getPropertyAsBoolean(REWIND_ON_THE_END);
    }

    public void setRewindOnTheEndOfList(boolean rewindOnTheEndOfList) {
        this.setProperty(REWIND_ON_THE_END, rewindOnTheEndOfList);
    }

    public boolean isIndependentListPerThread() {
        return this.getPropertyAsBoolean(INDEPENDENT_LIST_PER_THREAD);
    }

    public void setIndependentListPerThread(boolean independentListPerThread) {
        this.setProperty(INDEPENDENT_LIST_PER_THREAD, independentListPerThread);
    }

    private static class ThreadLocalSerializable<T>
    extends ThreadLocal<T>
    implements Serializable {
        private ThreadLocalSerializable() {
        }
    }
}

