/*
 * Decompiled with CFR 0.152.
 */
package com.kount.api;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import com.kount.api.CollectorTaskBase;
import com.kount.api.PostKey;
import com.kount.api.SoftError;
import java.util.Date;
import java.util.List;
import java.util.Locale;

class LocationCollector
extends CollectorTaskBase
implements LocationListener {
    private boolean foundLocation;
    private Location currentLocation;
    private final LocationManager locationManager;
    private static final int MS_IN_SECONDS = 1000;
    protected static final int LOCATION_MAX_AGE = 86400000;

    LocationCollector(Object debugHandler, Context ctx) {
        super(debugHandler);
        this.locationManager = (LocationManager)ctx.getSystemService("location");
    }

    @Override
    String getName() {
        return "Location Collector";
    }

    @Override
    String getInternalName() {
        return LocationCollector.internalName();
    }

    static String internalName() {
        return "collector_geo_loc";
    }

    @Override
    void collect() {
        Location location;
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
        boolean gpsEnabled = this.isProviderEnabled("gps");
        boolean networkEnabled = this.isProviderEnabled("network");
        boolean passiveEnabled = this.isProviderEnabled("passive");
        if (!gpsEnabled && !networkEnabled || !passiveEnabled) {
            this.debugMessage("Required providers not available for collection");
            this.addSoftError(SoftError.SERVICE_UNAVAILABLE.toString());
            this.callCompletionHandler(false, null);
            return;
        }
        List<String> providers = this.getLocationProviders();
        if (providers == null || providers.isEmpty()) {
            this.debugMessage("Required providers not available for collection");
            this.addSoftError(SoftError.SERVICE_UNAVAILABLE.toString());
            this.callCompletionHandler(false, null);
            return;
        }
        Date started = new Date();
        for (String provider : providers) {
            this.debugMessage(String.format("Requesting last known location from provider %s", provider));
            location = this.getLastKnownLocation(provider);
            this.checkLocation(location, provider, started);
        }
        if (!this.foundLocation) {
            this.debugMessage("No last known location found, querying for location");
            if (gpsEnabled) {
                this.makeLocationRequest("gps");
                location = this.getLastKnownLocation("gps");
                this.checkLocation(location, "gps", started);
            }
            if (!this.foundLocation && networkEnabled) {
                this.makeLocationRequest("network");
                location = this.getLastKnownLocation("network");
                this.checkLocation(location, "network", started);
            }
            if (!this.foundLocation) {
                this.callCompletionHandler(false, null);
                return;
            }
        }
        this.wrapUpLocationCollection();
    }

    private void checkLocation(Location location, String provider, Date started) {
        if (location != null) {
            this.debugMessage(String.format(Locale.US, "Got location for %s: %f, %f, %f", provider, location.getLongitude(), location.getLatitude(), Float.valueOf(location.getAccuracy())));
            long difference = started.getTime() - location.getTime();
            this.debugMessage(String.format(Locale.US, "Age: %d", difference));
            if (difference < 86400000L && this.isBetterLocation(location, this.currentLocation)) {
                this.debugMessage(location.getProvider() + " is a better location provider");
                this.currentLocation = location;
                this.foundLocation = true;
            }
        } else {
            this.debugMessage(provider + " found a null location");
        }
    }

    private boolean isBetterLocation(Location location, Location oldLocation) {
        if (oldLocation == null) {
            return true;
        }
        int accuracyDelta = (int)(location.getAccuracy() - oldLocation.getAccuracy());
        this.debugMessage("Accuracy delta is " + accuracyDelta);
        return accuracyDelta < 0;
    }

    protected boolean isProviderEnabled(String provider) {
        boolean enabled = false;
        try {
            enabled = this.locationManager.isProviderEnabled(provider);
            if (enabled) {
                this.debugMessage(String.format("%s provider exists and is enabled", provider));
            } else {
                this.debugMessage(String.format("%s provider does not exist or is not enabled", provider));
            }
        }
        catch (Exception e) {
            this.debugMessage(String.format("%s provider does not exist or is not enabled", provider));
        }
        return enabled;
    }

    private void wrapUpLocationCollection() {
        this.stopListeningForLocationUpdates();
        if (this.currentLocation != null) {
            this.addDataPoint(PostKey.LOCATION_LATITUDE.toString(), Double.toString(this.currentLocation.getLatitude()));
            this.addDataPoint(PostKey.LOCATION_LONGITUDE.toString(), Double.toString(this.currentLocation.getLongitude()));
            this.addDataPoint(PostKey.LOCATION_DATE.toString(), Long.toString(this.currentLocation.getTime() / 1000L));
            this.foundLocation = true;
        } else {
            this.debugMessage("No Location found.");
        }
        this.callCompletionHandler(true, null);
    }

    private void stopListeningForLocationUpdates() {
        try {
            this.locationManager.removeUpdates((LocationListener)this);
        }
        catch (SecurityException e) {
            this.debugMessage(String.format("SecurityException: %s", e.getMessage()));
        }
    }

    public void onLocationChanged(Location loc) {
        if (this.isBetterLocation(loc, this.currentLocation)) {
            this.currentLocation = loc;
        }
        this.stopListeningForLocationUpdates();
        this.wrapUpLocationCollection();
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle bundle) {
    }

    protected List<String> getLocationProviders() {
        return this.locationManager.getProviders(true);
    }

    protected Location getLastKnownLocation(String provider) {
        Location result = null;
        try {
            result = this.locationManager.getLastKnownLocation(provider);
        }
        catch (SecurityException e) {
            this.debugMessage(String.format("SecurityException: %s", e.getMessage()));
            this.addSoftError(SoftError.PERMISSION_DENIED.toString());
            this.callCompletionHandler(false, null);
        }
        catch (IllegalArgumentException e) {
            this.debugMessage(String.format("IllegalArgumentException from %s", e.getMessage()));
            this.addSoftError(SoftError.LOCATION_COLLECTOR_UNAVAILABLE.toString());
            this.callCompletionHandler(false, null);
        }
        return result;
    }

    protected void makeLocationRequest(String providerName) {
        try {
            if (!this.locationManager.isProviderEnabled(providerName)) {
                throw new IllegalArgumentException(String.format("Provider %s does not exist or is not enabled", providerName));
            }
            this.debugMessage(String.format("Requesting location from %s", providerName));
            this.locationManager.requestSingleUpdate(providerName, (LocationListener)this, null);
        }
        catch (SecurityException e) {
            this.debugMessage(String.format("SecurityException: %s", e.getMessage()));
            this.addSoftError(SoftError.PERMISSION_DENIED.toString());
            this.callCompletionHandler(false, null);
        }
        catch (IllegalArgumentException e) {
            this.debugMessage(String.format("IllegalArgumentException from %s: %s", providerName, e.getMessage()));
            this.addSoftError(SoftError.LOCATION_COLLECTOR_UNAVAILABLE.toString());
            this.callCompletionHandler(false, null);
        }
    }
}

