/*
 * Decompiled with CFR 0.152.
 */
package com.kount.api;

import android.util.Log;
import com.kount.api.DataCollector;
import java.lang.reflect.Method;
import java.util.Hashtable;

abstract class CollectorTaskBase {
    private final Hashtable<String, String> data = new Hashtable();
    private final Hashtable<String, String> softErrors = new Hashtable();
    static final String TAG = "DataCollector";
    private final Object debugHandler;
    String sessionID = null;
    protected boolean done = false;
    private RequestHandler completionHandler = null;

    CollectorTaskBase(Object debugHandler) {
        this.debugHandler = debugHandler;
    }

    abstract String getName();

    abstract String getInternalName();

    abstract void collect();

    void collectForSession(String sessionID, RequestHandler handler) {
        this.sessionID = sessionID;
        this.completionHandler = handler;
        this.debugMessage("Starting");
        if (this.debugHandler != null) {
            try {
                Method method = this.debugHandler.getClass().getDeclaredMethod("collectorStarted", String.class);
                method.setAccessible(true);
                method.invoke(this.debugHandler, this.getName());
            }
            catch (Exception e) {
                this.debugMessage(String.format("Exception: %s", e.getMessage()));
            }
        }
        this.collect();
    }

    void callCompletionHandler(Boolean success, DataCollector.Error error) {
        this.debugMessage(String.format("Completed with %s", success != false ? "Success" : "Failure"));
        if (this.debugHandler != null) {
            try {
                Method method = this.debugHandler.getClass().getDeclaredMethod("collectorDone", String.class, Boolean.class, DataCollector.Error.class);
                method.setAccessible(true);
                method.invoke(this.debugHandler, new Object[]{this.getName(), success, error});
            }
            catch (Exception e) {
                this.debugMessage(String.format("Exception: %s", e.getMessage()));
            }
        }
        this.done = true;
        this.completionHandler.completed(success, error, this.data, this.softErrors);
    }

    void addDataPoint(String key, String value) {
        if (value != null) {
            this.data.put(key, value);
        }
    }

    void addSoftError(String error) {
        this.softErrors.put(this.getInternalName(), error);
    }

    void debugMessage(String message) {
        if (this.debugHandler != null) {
            String formattedMessage = String.format("(%s) <%s> %s", this.sessionID, this.getName(), message);
            Log.d((String)TAG, (String)formattedMessage);
            try {
                Method method = this.debugHandler.getClass().getDeclaredMethod("collectorDebugMessage", String.class);
                method.setAccessible(true);
                method.invoke(this.debugHandler, formattedMessage);
            }
            catch (Exception e) {
                this.debugMessage(String.format("Exception: %s", e.getMessage()));
            }
        }
    }

    static interface RequestHandler {
        public void completed(Boolean var1, DataCollector.Error var2, Hashtable<String, String> var3, Hashtable<String, String> var4);
    }
}

