/*
 * Decompiled with CFR 0.152.
 */
package com.kount.api;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.kount.api.CollectorTaskBase;
import com.kount.api.PostKey;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class SystemCollector
extends CollectorTaskBase {
    private final WindowManager windowManager;

    SystemCollector(Object debugHandler, Context ctx) {
        super(debugHandler);
        this.windowManager = (WindowManager)ctx.getSystemService("window");
    }

    @Override
    final String getName() {
        return "System Collector";
    }

    @Override
    String getInternalName() {
        return SystemCollector.internalName();
    }

    static String internalName() {
        return "LOCAL";
    }

    @Override
    void collect() {
        this.addDataPoint(PostKey.MOBILE_MODEL.toString(), Build.FINGERPRINT);
        this.addDataPoint(PostKey.OS_VERSION.toString(), Build.VERSION.RELEASE);
        long systemCollectorMemoryDivisor = 0x100000L;
        long totalMemory = this.getTotalMemory() / systemCollectorMemoryDivisor;
        this.addDataPoint(PostKey.TOTAL_MEMORY.toString(), Long.toString(totalMemory));
        this.addDataPoint(PostKey.LANGUAGE.toString(), this.getLanguage());
        this.addDataPoint(PostKey.SCREEN_AVAILABLE.toString(), this.getScreenAvailable());
        this.addDataPoint(PostKey.TIMEZONE_AUGUST.toString(), Long.toString(this.getTimeZoneOffsetAugust()));
        this.addDataPoint(PostKey.TIMEZONE_FEBRUARY.toString(), Long.toString(this.getTimeZoneOffsetFebruary()));
        this.addDataPoint(PostKey.TIMEZONE_NOW.toString(), Long.toString(this.getTimeZoneOffset()));
        Date date = new Date();
        this.addDataPoint(PostKey.DATE_TIME.toString(), Long.toString(date.getTime()));
        this.callCompletionHandler(true, null);
    }

    protected long getTotalMemory() {
        String str1 = "/proc/meminfo";
        long initial_memory = 0L;
        try {
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            initial_memory = Integer.valueOf(arrayOfString[1]) * 1024;
            localBufferedReader.close();
            return initial_memory;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    protected String getLanguage() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    protected String getScreenAvailable() {
        Display display = this.windowManager.getDefaultDisplay();
        int realWidth = display.getWidth();
        int realHeight = display.getHeight();
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics realMetrics = new DisplayMetrics();
            display.getRealMetrics(realMetrics);
            realWidth = realMetrics.widthPixels;
            realHeight = realMetrics.heightPixels;
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                Method mGetRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                Method mGetRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                realWidth = (Integer)mGetRawW.invoke((Object)display, new Object[0]);
                realHeight = (Integer)mGetRawH.invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return realHeight + "x" + realWidth;
    }

    protected int getTimeZoneOffsetAugust() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2007, 7, 1);
        return this.getTimeZoneOffset(calendar);
    }

    protected int getTimeZoneOffsetFebruary() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2007, 1, 1);
        return this.getTimeZoneOffset(calendar);
    }

    protected int getTimeZoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        return this.getTimeZoneOffset(calendar);
    }

    protected int getTimeZoneOffset(Calendar calendar) {
        TimeZone timeZone = TimeZone.getDefault();
        return -1 * timeZone.getOffset(calendar.getTimeInMillis()) / 1000 / 60;
    }
}

