/*
 * Decompiled with CFR 0.152.
 */
package com.kount.api;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.kount.api.CollectorTaskBase;
import com.kount.api.FingerprintCollector;
import com.kount.api.LocationCollector;
import com.kount.api.PostKey;
import com.kount.api.SoftError;
import com.kount.api.SystemCollector;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class DataCollector {
    private static final int ENVIRONMENT_UNKNOWN = 0;
    public static final int ENVIRONMENT_TEST = 1;
    public static final int ENVIRONMENT_PRODUCTION = 2;
    static final int ENVIRONMENT_QA = 999999;
    public static final String VERSION = "3.2";
    private static DataCollector instance = null;
    private static final Object lock = new Object();
    private int merchantID;
    private boolean debug;
    protected String collectionURL;
    private int environment = 0;
    private int timeoutInMS = 15000;
    private LocationConfig locationConfig = LocationConfig.COLLECT;
    private Context context = null;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String TAG = "DataCollector";

    public void setContext(Context context) {
        this.context = context;
    }

    public void setMerchantID(int merchantID) {
        this.debugMessage(null, String.format(Locale.US, "Setting Merchant ID to %d.", merchantID));
        this.merchantID = merchantID;
    }

    public void setEnvironment(int env) {
        switch (env) {
            case 1: {
                this.debugMessage(null, "Setting Environment to Test");
                this.setURL("https://tst.kaptcha.com/m.html");
                break;
            }
            case 2: {
                this.debugMessage(null, "Setting Environment to Production");
                this.setURL("https://ssl.kaptcha.com/m.html");
                break;
            }
            case 999999: {
                this.debugMessage(null, "Setting Environment to QA");
                this.setURL("https://mqa.kaptcha.com/m.html");
                break;
            }
            default: {
                this.environment = 0;
                this.debugMessage(null, "Invalid Environment");
                this.collectionURL = null;
                return;
            }
        }
        this.environment = env;
    }

    protected void setURL(String collectionURL) {
        this.debugMessage(null, String.format("Setting Collection URL to %s.", collectionURL));
        this.collectionURL = collectionURL;
    }

    public void setTimeoutInMS(int timeout) {
        this.debugMessage(null, String.format(Locale.US, "Setting timeout to %d ms.", timeout));
        this.timeoutInMS = timeout;
    }

    public void setLocationCollectorConfig(LocationConfig config) {
        switch (config) {
            case COLLECT: {
                this.debugMessage(null, "Location collection enabled.");
                break;
            }
            case SKIP: {
                this.debugMessage(null, "Skipping location collection.");
            }
        }
        this.locationConfig = config;
    }

    protected DataCollector() {
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
        this.debugMessage(null, "Enabling debug to console.");
    }

    private void debugMessage(Object debugHandler, String message) {
        if (this.debug) {
            Log.d((String)TAG, (String)String.format("<Data Collector> %s", message));
        }
        if (debugHandler != null) {
            try {
                Method method = debugHandler.getClass().getDeclaredMethod("collectorDebugMessage", String.class);
                method.setAccessible(true);
                method.invoke(debugHandler, message);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)String.format("Exception: %s", e.getMessage()));
            }
        }
    }

    public static DataCollector getInstance() {
        if (instance == null) {
            instance = new DataCollector();
        }
        return instance;
    }

    public void collectForSession(String sessionID, CompletionHandler handler) {
        this.collectForSession(sessionID, handler, null);
    }

    protected boolean noNetwork(Context ctx) {
        try {
            ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            return ni == null || !ni.isConnectedOrConnecting();
        }
        catch (Exception e) {
            return true;
        }
    }

    private String formatDataForServer(Hashtable<String, String> dataForSubmission, Hashtable<String, String> softErrorsForSubmission, String sessionID) {
        StringBuilder urlString = new StringBuilder();
        try {
            urlString.append(String.format(Locale.US, "%s=%d&%s=%s", URLEncoder.encode(PostKey.MERCHANT_ID.toString(), "UTF-8"), this.merchantID, URLEncoder.encode(PostKey.SESSION_ID.toString(), "UTF-8"), URLEncoder.encode(sessionID, "UTF-8")));
            for (String key : dataForSubmission.keySet()) {
                urlString.append(String.format("&%s=%s", URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(dataForSubmission.get(key), "UTF-8")));
            }
            if (softErrorsForSubmission.size() > 0) {
                JSONObject deviceCookiesJSON = new JSONObject(softErrorsForSubmission);
                urlString.append(String.format(Locale.US, "&%s=%s", URLEncoder.encode(PostKey.SOFT_ERRORS.toString(), "UTF-8"), URLEncoder.encode(deviceCookiesJSON.toString(), "UTF-8")));
            }
            return urlString.toString();
        }
        catch (Exception c) {
            return null;
        }
    }

    private void callCompletionHandler(final CompletionHandler handler, final Object debugHandler, final String sessionID, final Boolean success, final Error error) {
        if (handler != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (success.booleanValue()) {
                        DataCollector.this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Collector completed successfully.", sessionID));
                        handler.completed(sessionID);
                    } else {
                        handler.failed(sessionID, error);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMobileDataToServer(Object debugHandler, String sessionID, String serverName, String payload) {
        if (null != serverName) {
            HttpURLConnection urlConnection = null;
            String urlString = serverName + "/m.html";
            this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Posting data:\n%s", sessionID, payload));
            URL url = new URL(urlString);
            urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            OutputStream stream = urlConnection.getOutputStream();
            stream.write(payload.getBytes());
            stream.flush();
            stream.close();
            if (urlConnection.getResponseCode() == 200) {
                this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Sent data to %s.", sessionID, url));
            } else {
                this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Failed to send data to %s: Response code: %d", sessionID, url, urlConnection.getResponseCode()));
            }
            if (urlConnection == null) return;
            try {
                urlConnection.disconnect();
                return;
            }
            catch (Exception e) {
                this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Exception encountered sending data: %s", sessionID, e.getMessage()));
            }
            return;
            catch (Exception e) {
                try {
                    this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Exception encountered sending data: %s", sessionID, e.getMessage()));
                    if (urlConnection == null) return;
                }
                catch (Throwable throwable) {
                    if (urlConnection == null) throw throwable;
                    try {
                        urlConnection.disconnect();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Exception encountered sending data: %s", sessionID, e2.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    urlConnection.disconnect();
                    return;
                }
                catch (Exception e3) {
                    this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Exception encountered sending data: %s", sessionID, e3.getMessage()));
                }
                return;
            }
        }
        this.debugMessage(debugHandler, String.format("(%s) No server URL to send data to, skipping send.", sessionID));
    }

    protected LocationCollector createLocationCollector(Object debugHandler) {
        return new LocationCollector(debugHandler, this.context);
    }

    protected void collectForSession(final String sessionID, final CompletionHandler handler, final Object debugHandler) {
        if (this.context == null) {
            this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.CONTEXT_NOT_SET);
        } else {
            this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Adding to queue", sessionID));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Date startTime = new Date();
                    DataCollector.this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Starting collection", sessionID));
                    if (null == DataCollector.this.collectionURL || !DataCollector.this.collectionURL.matches("^https?://[\\w-]+(\\.[\\w-]+)+(/[^?]*)?$")) {
                        DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.INVALID_ENVIRONMENT);
                        return;
                    }
                    if (DataCollector.this.environment != 2 && DataCollector.this.environment != 1 && DataCollector.this.environment != 999999) {
                        DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.INVALID_ENVIRONMENT);
                        return;
                    }
                    if (DataCollector.this.merchantID <= 0 || DataCollector.this.merchantID > 999999) {
                        DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.INVALID_MERCHANT);
                        return;
                    }
                    if (null == sessionID || !sessionID.matches("^[\\w-]{1,32}$")) {
                        DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.INVALID_SESSION);
                        return;
                    }
                    if (DataCollector.this.noNetwork(DataCollector.this.context)) {
                        DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.NO_NETWORK);
                        return;
                    }
                    final Hashtable<String, String> dataForSubmission = new Hashtable<String, String>();
                    final Hashtable<String, String> softErrorsForSubmission = new Hashtable<String, String>();
                    final ArrayList errors = new ArrayList();
                    LinkedBlockingQueue<Runnable> sessionQueue = new LinkedBlockingQueue<Runnable>();
                    ThreadPoolExecutor sessionExecutor = new ThreadPoolExecutor(10, 10, 1000L, TimeUnit.MILLISECONDS, sessionQueue);
                    ArrayList<CollectorTaskBase> collectors = new ArrayList<CollectorTaskBase>();
                    if (DataCollector.this.locationConfig == LocationConfig.COLLECT) {
                        collectors.add(DataCollector.this.createLocationCollector(debugHandler));
                    } else {
                        softErrorsForSubmission.put(LocationCollector.internalName(), SoftError.SKIPPED.toString());
                    }
                    collectors.add(new SystemCollector(debugHandler, DataCollector.this.context));
                    collectors.add(new FingerprintCollector(debugHandler, DataCollector.this.context));
                    for (final CollectorTaskBase collector : collectors) {
                        sessionExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                final Semaphore semaphore = new Semaphore(1);
                                try {
                                    semaphore.acquire();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                collector.collectForSession(sessionID, new CollectorTaskBase.RequestHandler(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void completed(Boolean success, Error error, Hashtable<String, String> collectedData, Hashtable<String, String> softErrors) {
                                        Object object = lock;
                                        synchronized (object) {
                                            for (String key : collectedData.keySet()) {
                                                dataForSubmission.put(key, collectedData.get(key));
                                            }
                                            for (String key : softErrors.keySet()) {
                                                softErrorsForSubmission.put(key, softErrors.get(key));
                                            }
                                            if (error != null) {
                                                errors.add(error);
                                            }
                                        }
                                        semaphore.release();
                                    }
                                });
                                try {
                                    semaphore.tryAcquire(DataCollector.this.timeoutInMS, TimeUnit.MILLISECONDS);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    sessionExecutor.shutdown();
                    try {
                        sessionExecutor.awaitTermination(DataCollector.this.timeoutInMS, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        DataCollector.this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Exception encountered waiting for threads: %s", sessionID, e.getMessage()));
                    }
                    if (errors.size() > 0) {
                        DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, (Error)((Object)errors.get(0)));
                    } else {
                        Date now = new Date();
                        long elapsed = now.getTime() - startTime.getTime();
                        DataCollector.this.debugMessage(debugHandler, String.format(Locale.US, "(%s) Collection time: %d ms.", sessionID, elapsed));
                        dataForSubmission.put(PostKey.ELAPSED.toString(), Long.toString(elapsed));
                        dataForSubmission.put(PostKey.SDK_TYPE.toString(), "A");
                        dataForSubmission.put(PostKey.SDK_VERSION.toString(), DataCollector.VERSION);
                        String postBodyString = DataCollector.this.formatDataForServer(dataForSubmission, softErrorsForSubmission, sessionID);
                        if (postBodyString != null) {
                            String collectionURLHost;
                            try {
                                URI uri = new URI(DataCollector.this.collectionURL);
                                collectionURLHost = String.format("https://%s", uri.getHost());
                                DataCollector.this.debugMessage(debugHandler, String.format("Collection host is: %s", collectionURLHost));
                            }
                            catch (URISyntaxException e) {
                                DataCollector.this.debugMessage(debugHandler, "Error parsing collection host name");
                                DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.INVALID_ENVIRONMENT);
                                return;
                            }
                            DataCollector.this.sendMobileDataToServer(debugHandler, sessionID, collectionURLHost, postBodyString);
                            DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, true, null);
                        } else {
                            DataCollector.this.callCompletionHandler(handler, debugHandler, sessionID, false, Error.RUNTIME_FAILURE);
                        }
                    }
                }
            });
        }
    }

    protected static interface DebugHandler {
        public void collectorDebugMessage(String var1);

        public void collectorDone(String var1, Boolean var2, Error var3);

        public void collectorStarted(String var1);
    }

    public static interface CompletionHandler {
        public void completed(String var1);

        public void failed(String var1, Error var2);
    }

    public static enum Error {
        NO_NETWORK(0, "No network"),
        INVALID_ENVIRONMENT(1, "Invalid Environment"),
        INVALID_MERCHANT(2, "Invalid Merchant ID"),
        INVALID_SESSION(3, "Invalid Session ID"),
        RUNTIME_FAILURE(4, "Runtime Failure"),
        VALIDATION_FAILURE(5, "Validation Failure"),
        TIMEOUT(6, "Timeout"),
        CONTEXT_NOT_SET(7, "Context Not Set");

        private final int code;
        private final String description;

        private Error(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.code + ": " + this.description;
        }
    }

    public static enum LocationConfig {
        COLLECT,
        SKIP;

    }
}

