/*
 * Decompiled with CFR 0.152.
 */
package com.kount.api;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import com.kount.api.CollectorTaskBase;
import com.kount.api.HashUtils;
import com.kount.api.PostKey;
import com.kount.api.SoftError;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONObject;

class FingerprintCollector
extends CollectorTaskBase {
    protected Context context = null;
    private static final String PREF_FILE = "k_prefs";
    private static final String PREF_KEY = "lic";

    FingerprintCollector(Object debugHandler, Context ctx) {
        super(debugHandler);
        this.context = ctx;
    }

    @Override
    String getName() {
        return "Fingerprint Collector";
    }

    @Override
    String getInternalName() {
        return FingerprintCollector.internalName();
    }

    static String internalName() {
        return "collector_device_cookie";
    }

    @Override
    void collect() {
        HashMap<String, String> deviceCookies = new HashMap<String, String>();
        String androidID = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        this.debugMessage(String.format("Android ID = %s", androidID));
        deviceCookies.put(DeviceIDType.ANDROID_ID.toString(), HashUtils.convertToSha256Hash(DeviceIDType.ANDROID_ID.toString() + androidID));
        deviceCookies.put(DeviceIDType.ANDROID_SERIAL.toString(), HashUtils.convertToSha256Hash(DeviceIDType.ANDROID_SERIAL.toString() + Build.SERIAL));
        String macArray = this.getMACAddresses();
        if (macArray != null) {
            deviceCookies.put(DeviceIDType.MAC_HASH.toString(), HashUtils.convertToSha256Hash(DeviceIDType.MAC_HASH.toString() + macArray));
        }
        String oldCookies = this.readCookies();
        String uid = null;
        if (oldCookies != null && oldCookies.contains(DeviceIDType.UID.toString())) {
            try {
                int start = oldCookies.indexOf(DeviceIDType.UID.toString()) + DeviceIDType.UID.toString().length() + 3;
                int end = oldCookies.indexOf(34, start);
                uid = oldCookies.substring(start, end);
            }
            catch (IndexOutOfBoundsException start) {
                // empty catch block
            }
        }
        if (null == uid) {
            uid = HashUtils.convertToSha256Hash(DeviceIDType.UID.toString() + UUID.randomUUID().toString());
        }
        deviceCookies.put(DeviceIDType.UID.toString(), uid);
        JSONObject deviceCookiesJSON = new JSONObject(deviceCookies);
        this.addDataPoint(PostKey.DEVICE_COOKIE.toString(), deviceCookiesJSON.toString());
        if (oldCookies != null) {
            this.addDataPoint(PostKey.OLD_DEVICE_COOKIE.toString(), oldCookies);
        }
        this.saveCookies(deviceCookiesJSON.toString());
        this.callCompletionHandler(true, null);
    }

    protected String readCookies() {
        SharedPreferences sp = this.context.getSharedPreferences(PREF_FILE, 0);
        if (sp != null) {
            return sp.getString(PREF_KEY, null);
        }
        return null;
    }

    private void saveCookies(String cookies) {
        SharedPreferences sp = this.context.getSharedPreferences(PREF_FILE, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(PREF_KEY, cookies);
        editor.apply();
    }

    private String getMACAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            String macAddress;
            WifiManager wifiManager = (WifiManager)this.context.getSystemService("wifi");
            WifiInfo wifi = wifiManager.getConnectionInfo();
            if (wifi != null && (macAddress = wifi.getMacAddress()) != null) {
                addresses.add(macAddress.replace(":", ""));
            }
            this.debugMessage("Wi-Fi not enabled, skipping.");
        }
        catch (SecurityException se) {
            this.debugMessage("Wi-Fi permission denied.");
        }
        try {
            Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
            while (niEnum.hasMoreElements()) {
                NetworkInterface ni = niEnum.nextElement();
                if (!ni.isUp()) continue;
                this.debugMessage(String.format("Network:%s, virtual:%s.", ni.getName(), ni.isVirtual() ? "true" : "false"));
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
                addresses.add(sb.toString());
            }
        }
        catch (SocketException se) {
            this.debugMessage("Bad socket connection, skipping.");
            this.addSoftError(SoftError.SERVICE_UNAVAILABLE.toString());
        }
        catch (SecurityException se) {
            this.debugMessage("Permission denied, skipping.");
            this.addSoftError(SoftError.PERMISSION_DENIED.toString());
        }
        Collections.sort(addresses);
        if (addresses.size() > 0) {
            StringBuilder macList = new StringBuilder("{");
            for (String value : addresses) {
                macList.append(value);
                macList.append(",");
            }
            macList.append("}");
            return macList.toString();
        }
        return null;
    }

    static enum DeviceIDType {
        ANDROID_ID("ANDROID_ID"),
        ANDROID_SERIAL("ANDROID_SERIAL"),
        MAC_HASH("MAC_HASH"),
        UID("UID");

        private final String name;

        private DeviceIDType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

