/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.RuleSelector;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.RuleSetResolverException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.impl.RuleSelectorImpl;
import com.buschmais.jqassistant.core.analysis.impl.RuleSetReaderImpl;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ReportPluginRepository;
import com.buschmais.jqassistant.core.plugin.api.RulePluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.plugin.impl.ReportPluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.RulePluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.ScannerPluginRepositoryImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.Aggregator;
import com.buschmais.jqassistant.scm.maven.StoreRepository;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.DirectoryWalker;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractAnalysisMojo
extends AbstractMojo {
    public static final String REPORT_XML = "jqassistant-report.xml";
    @Parameter(property="jqassistant.store.directory")
    protected File storeDirectory;
    @Parameter(property="jqassistant.rules.directory")
    protected File rulesDirectory;
    @Parameter(property="jqassistant.rules.url")
    protected URL rulesUrl;
    @Parameter(property="jqassistant.concepts")
    protected List<String> concepts;
    @Parameter(property="jqassistant.constraints")
    protected List<String> constraints;
    @Parameter(property="jqassistant.groups")
    protected List<String> groups;
    @Parameter(property="jqassistant.report.xml")
    protected File xmlReportFile;
    @Parameter(property="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Parameter(property="project")
    private MavenProject currentProject;
    @Component
    private StoreRepository storeRepository;
    private PluginConfigurationReader pluginConfigurationReader = new PluginConfigurationReaderImpl();
    private RuleSetReader ruleSetReader = new RuleSetReaderImpl();
    private RuleSelector ruleSelector = new RuleSelectorImpl();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Aggregator.execute(new Aggregator.AggregatedGoal(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(MavenProject baseProject, Set<MavenProject> projects) throws MojoExecutionException, MojoFailureException {
                List descriptorTypes;
                Store store = AbstractAnalysisMojo.this.getStore(baseProject);
                try {
                    descriptorTypes = AbstractAnalysisMojo.this.getScannerPluginRepository(store, AbstractAnalysisMojo.this.getPluginProperties(baseProject)).getDescriptorTypes();
                }
                catch (PluginRepositoryException e) {
                    throw new MojoExecutionException("Cannot get descriptor mappers.", (Exception)((Object)e));
                }
                try {
                    store.start((Collection)descriptorTypes);
                    AbstractAnalysisMojo.this.aggregate(baseProject, projects, store);
                }
                finally {
                    store.stop();
                }
            }
        }, this.currentProject, this.reactorProjects);
    }

    protected ScannerPluginRepository getScannerPluginRepository(Store store, Map<String, Object> properties) throws MojoExecutionException {
        try {
            return new ScannerPluginRepositoryImpl(this.pluginConfigurationReader, store, properties);
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot create rule plugin repository.", (Exception)((Object)e));
        }
    }

    protected RulePluginRepository getRulePluginRepository() throws MojoExecutionException {
        try {
            return new RulePluginRepositoryImpl(this.pluginConfigurationReader);
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot create rule plugin repository.", (Exception)((Object)e));
        }
    }

    protected ReportPluginRepository getReportPluginRepository(Map<String, Object> properties) throws MojoExecutionException {
        try {
            return new ReportPluginRepositoryImpl(this.pluginConfigurationReader, properties);
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot create rule plugin repository.", (Exception)((Object)e));
        }
    }

    protected RuleSet readRules(MavenProject baseProject) throws MojoExecutionException {
        File selectedDirectory = this.rulesDirectory != null ? this.rulesDirectory : new File(baseProject.getBasedir(), "jqassistant");
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        if (selectedDirectory != null) {
            List<File> ruleFiles = this.readRulesDirectory(selectedDirectory);
            for (File ruleFile : ruleFiles) {
                this.getLog().debug((CharSequence)("Adding rules from file " + ruleFile.getAbsolutePath()));
                sources.add(new StreamSource(ruleFile));
            }
        }
        if (this.rulesUrl != null) {
            try {
                sources.add(new StreamSource(this.rulesUrl.openStream(), this.rulesUrl.toExternalForm()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot open rule URL " + this.rulesUrl.toExternalForm());
            }
        }
        List ruleSources = this.getRulePluginRepository().getRuleSources();
        sources.addAll(ruleSources);
        return this.ruleSetReader.read(sources);
    }

    protected RuleSet resolveEffectiveRules(MavenProject baseProject) throws MojoExecutionException {
        RuleSet ruleSet = this.readRules(baseProject);
        this.validateRuleSet(ruleSet);
        try {
            return this.ruleSelector.getEffectiveRuleSet(ruleSet, this.concepts, this.constraints, this.groups);
        }
        catch (RuleSetResolverException e) {
            throw new MojoExecutionException("Cannot resolve rules.", (Exception)((Object)e));
        }
    }

    protected Map<String, Object> getPluginProperties(MavenProject project) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(MavenProject.class.getName(), project);
        return properties;
    }

    protected Store getStore(MavenProject baseProject) throws MojoExecutionException {
        File directory = this.storeDirectory != null ? this.storeDirectory : new File(baseProject.getBuild().getDirectory() + "/jqassistant/store");
        return this.storeRepository.getStore(directory, this.isResetStoreOnInitialization());
    }

    protected abstract boolean isResetStoreOnInitialization();

    protected abstract void aggregate(MavenProject var1, Set<MavenProject> var2, Store var3) throws MojoExecutionException, MojoFailureException;

    private List<File> readRulesDirectory(File rulesDirectory) throws MojoExecutionException {
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new MojoExecutionException(rulesDirectory.getAbsolutePath() + " does not exist or is not a rulesDirectory.");
        }
        this.getLog().info((CharSequence)("Reading rules from rulesDirectory " + rulesDirectory.getAbsolutePath()));
        final ArrayList<File> ruleFiles = new ArrayList<File>();
        try {
            new DirectoryWalker<File>(){

                protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
                    if (!file.isDirectory() && file.getName().endsWith(".xml")) {
                        results.add(file);
                    }
                }

                public void scan(File directory) throws IOException {
                    super.walk(directory, (Collection)ruleFiles);
                }
            }.scan(rulesDirectory);
            return ruleFiles;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read rulesDirectory: " + rulesDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    private void validateRuleSet(RuleSet ruleSet) throws MojoExecutionException {
        StringBuffer message = new StringBuffer();
        if (!ruleSet.getMissingConcepts().isEmpty()) {
            message.append("\n  Concepts: ");
            message.append(ruleSet.getMissingConcepts());
        }
        if (!ruleSet.getMissingConstraints().isEmpty()) {
            message.append("\n  Constraints: ");
            message.append(ruleSet.getMissingConstraints());
        }
        if (!ruleSet.getMissingGroups().isEmpty()) {
            message.append("\n  Groups: ");
            message.append(ruleSet.getMissingGroups());
        }
        if (message.length() > 0) {
            throw new MojoExecutionException("The following rules are referenced but are not available;" + message);
        }
    }
}

