/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.scm.maven.BaseProjectResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public final class Aggregator {
    private Aggregator() {
    }

    public static void execute(AggregatedGoal goal, MavenProject currentProject, List<MavenProject> reactorProjects) throws MojoExecutionException, MojoFailureException {
        MavenProject baseProject;
        MavenProject current;
        HashSet<MavenProject> executedProjects = new HashSet<MavenProject>();
        Iterator<MavenProject> iterator = reactorProjects.iterator();
        do {
            current = iterator.next();
            executedProjects.add(current);
        } while (iterator.hasNext() && !currentProject.equals((Object)current));
        Map<MavenProject, List<MavenProject>> baseProjects = Aggregator.getBaseProjects(reactorProjects);
        List<MavenProject> currentProjects = baseProjects.get(baseProject = BaseProjectResolver.getBaseProject(currentProject));
        if (currentProjects != null && currentProject.equals((Object)currentProjects.get(currentProjects.size() - 1))) {
            goal.execute(baseProject, new HashSet<MavenProject>(currentProjects));
        }
    }

    private static Map<MavenProject, List<MavenProject>> getBaseProjects(List<MavenProject> reactorProjects) throws MojoExecutionException {
        HashMap<MavenProject, List<MavenProject>> baseProjects = new HashMap<MavenProject, List<MavenProject>>();
        for (MavenProject reactorProject : reactorProjects) {
            MavenProject baseProject = BaseProjectResolver.getBaseProject(reactorProject);
            ArrayList<MavenProject> projects = (ArrayList<MavenProject>)baseProjects.get(baseProject);
            if (projects == null) {
                projects = new ArrayList<MavenProject>();
                baseProjects.put(baseProject, projects);
            }
            projects.add(reactorProject);
        }
        return baseProjects;
    }

    public static interface AggregatedGoal {
        public void execute(MavenProject var1, Set<MavenProject> var2) throws MojoExecutionException, MojoFailureException;
    }
}

