/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.impl.CompositeReportWriter;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.report.impl.XmlReportWriter;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractAnalysisMojo;
import com.buschmais.jqassistant.scm.maven.BaseProjectResolver;
import com.buschmais.jqassistant.scm.maven.MavenConsole;
import com.buschmais.jqassistant.scm.maven.report.JUnitReportWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY)
public class AnalyzeMojo
extends AbstractAnalysisMojo {
    @Parameter(property="jqassistant.failOnConstraintViolations", defaultValue="true")
    protected boolean failOnConstraintViolations;
    @Parameter(property="jqassistant.junitReportDirectory")
    private File junitReportDirectory;
    @Parameter(property="jqassistant.reportTypes")
    private List<ReportType> reportTypes;
    @Parameter(property="jqassistant.reportProperties")
    private Map<String, Object> reportProperties;

    @Override
    public void aggregate(MavenProject baseProject, Set<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Executing analysis for '" + baseProject.getName() + "'."));
        RuleSet ruleSet = this.resolveEffectiveRules(baseProject);
        LinkedList<Object> reportWriters = new LinkedList<Object>();
        InMemoryReportWriter inMemoryReportWriter = new InMemoryReportWriter();
        reportWriters.add(inMemoryReportWriter);
        if (this.reportTypes == null || this.reportTypes.isEmpty()) {
            this.reportTypes = Arrays.asList(ReportType.JQA);
        }
        for (ReportType reportType : this.reportTypes) {
            switch (reportType) {
                case JQA: {
                    XmlReportWriter xmlReportWriter;
                    FileWriter xmlReportFileWriter;
                    try {
                        xmlReportFileWriter = new FileWriter(this.getXmlReportFile(baseProject));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Cannot create XML report file.", (Exception)e);
                    }
                    try {
                        xmlReportWriter = new XmlReportWriter((Writer)xmlReportFileWriter);
                    }
                    catch (AnalysisListenerException e) {
                        throw new MojoExecutionException("Cannot create XML report file writer.", (Exception)((Object)e));
                    }
                    reportWriters.add(xmlReportWriter);
                    break;
                }
                case JUNIT: {
                    reportWriters.add(this.getJunitReportWriter(baseProject));
                }
            }
        }
        Map<String, Object> properties = this.reportProperties != null ? this.reportProperties : Collections.emptyMap();
        List reportPlugins = this.getReportPluginRepository(properties).getReportPlugins();
        reportWriters.addAll(reportPlugins);
        CompositeReportWriter reportWriter = new CompositeReportWriter(reportWriters);
        MavenConsole console = new MavenConsole(this.getLog());
        AnalyzerImpl analyzer = new AnalyzerImpl(store, (AnalysisListener)reportWriter, (Console)console);
        try {
            analyzer.execute(ruleSet);
        }
        catch (AnalysisException e) {
            throw new MojoExecutionException("Analysis failed.", (Exception)((Object)e));
        }
        ReportHelper reportHelper = new ReportHelper((Console)console);
        store.beginTransaction();
        try {
            reportHelper.verifyConceptResults(inMemoryReportWriter);
            int violations = reportHelper.verifyConstraintViolations(inMemoryReportWriter);
            if (this.failOnConstraintViolations && violations > 0) {
                throw new MojoFailureException(violations + " constraints have been violated!");
            }
        }
        catch (AnalysisListenerException e) {
            throw new MojoExecutionException("Cannot print report.", (Exception)((Object)e));
        }
        finally {
            store.commitTransaction();
        }
    }

    private JUnitReportWriter getJunitReportWriter(MavenProject baseProject) throws MojoExecutionException {
        JUnitReportWriter junitReportWriter;
        if (this.junitReportDirectory == null) {
            this.junitReportDirectory = new File(baseProject.getBuild().getDirectory() + "/surefire-reports");
        }
        this.junitReportDirectory.mkdirs();
        try {
            junitReportWriter = new JUnitReportWriter(this.junitReportDirectory);
        }
        catch (AnalysisListenerException e) {
            throw new MojoExecutionException("Cannot create XML report file writer.", (Exception)((Object)e));
        }
        return junitReportWriter;
    }

    private File getXmlReportFile(MavenProject baseProject) throws MojoExecutionException {
        File selectedXmlReportFile = BaseProjectResolver.getOutputFile(baseProject, this.xmlReportFile, "jqassistant-report.xml");
        selectedXmlReportFile.getParentFile().mkdirs();
        return selectedXmlReportFile;
    }

    @Override
    protected boolean isResetStoreOnInitialization() {
        return false;
    }

    public static enum ReportType {
        JQA,
        JUNIT;

    }
}

