/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class BaseProjectResolver {
    public static final String RULES_DIRECTORY = "jqassistant";
    public static final String OUTPUT_DIRECTORY = "jqassistant";

    private BaseProjectResolver() {
    }

    static MavenProject getBaseProject(MavenProject project) throws MojoExecutionException {
        MavenProject currentProject = project;
        if (project != null) {
            MavenProject parent;
            do {
                File directory;
                if ((directory = new File(currentProject.getBasedir(), "jqassistant")).exists() && directory.isDirectory()) {
                    return currentProject;
                }
                parent = currentProject.getParent();
                if (parent != null && parent.getBasedir() != null) continue;
                return currentProject;
            } while ((currentProject = parent) != null);
        }
        throw new MojoExecutionException("Cannot resolve base directory.");
    }

    static File getOutputDirectory(MavenProject baseProject) {
        String directoryName = baseProject.getBuild().getDirectory() + "/" + "jqassistant";
        File directory = new File(directoryName);
        directory.mkdirs();
        return directory;
    }

    static File getOutputFile(MavenProject baseProject, File reportFile, String defaultFile) throws MojoExecutionException {
        File selectedXmlReportFile;
        if (reportFile != null) {
            selectedXmlReportFile = reportFile;
        } else if (baseProject != null) {
            selectedXmlReportFile = new File(BaseProjectResolver.getOutputDirectory(baseProject) + "/" + defaultFile);
        } else {
            throw new MojoExecutionException("Cannot determine report file.");
        }
        return selectedXmlReportFile;
    }
}

