/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.scm.maven.AbstractAnalysisMojo;
import com.buschmais.jqassistant.scm.maven.BaseProjectResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.export.SubGraphExporter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseAPI;

@Mojo(name="export-database")
public class ExportDatabaseMojo
extends AbstractAnalysisMojo {
    private static final String EXPORT_FILE = "jqassistant.cypher";
    @Parameter(property="jqassistant.export.file")
    protected File exportFile;

    @Override
    protected void aggregate(MavenProject baseProject, Set<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        EmbeddedGraphStore graphStore = (EmbeddedGraphStore)store;
        GraphDatabaseAPI databaseService = graphStore.getDatabaseService();
        File file = BaseProjectResolver.getOutputFile(baseProject, this.exportFile, EXPORT_FILE);
        this.getLog().info((CharSequence)("Exporting database to '" + file.getAbsolutePath() + "'"));
        store.beginTransaction();
        SubGraph graph = DatabaseSubGraph.from((GraphDatabaseService)databaseService);
        try {
            new SubGraphExporter(graph).export(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot export database.", (Exception)e);
        }
        finally {
            store.commitTransaction();
        }
    }

    @Override
    protected boolean isResetStoreOnInitialization() {
        return false;
    }
}

