/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.report.api.ReportTransformerException;
import com.buschmais.jqassistant.core.report.impl.HtmlReportTransformer;
import com.buschmais.jqassistant.scm.maven.BaseProjectResolver;
import java.io.File;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
public class ReportMojo
extends AbstractMavenReport {
    @Parameter(property="project.reporting.outputDirectory")
    protected String outputDirectory;
    @Parameter(property="jqassistant.report.xml")
    protected File xmlReportFile;
    @Parameter(property="project")
    protected MavenProject project;
    @Component
    protected Renderer siteRenderer;

    protected void executeReport(Locale locale) throws MavenReportException {
        File selectedXmlReportFile;
        MavenProject baseProject;
        try {
            baseProject = BaseProjectResolver.getBaseProject(this.project);
            selectedXmlReportFile = BaseProjectResolver.getOutputFile(baseProject, this.xmlReportFile, "jqassistant-report.xml");
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Cannot resolve XML report.", (Exception)((Object)e));
        }
        if (this.project.equals((Object)baseProject)) {
            if (!selectedXmlReportFile.exists() || selectedXmlReportFile.isDirectory()) {
                throw new MavenReportException(selectedXmlReportFile.getAbsoluteFile() + " does not exist or is not a file.");
            }
            StringWriter writer = new StringWriter();
            StreamSource xmlSource = new StreamSource(selectedXmlReportFile);
            StreamResult htmlTarget = new StreamResult(writer);
            this.getLog().info((CharSequence)("Transforming " + selectedXmlReportFile.getAbsolutePath() + "."));
            HtmlReportTransformer transformer = new HtmlReportTransformer();
            try {
                transformer.transform((Source)xmlSource, (Result)htmlTarget);
            }
            catch (ReportTransformerException e) {
                throw new MavenReportException("Cannot transform report.", (Exception)((Object)e));
            }
            this.getSink().rawText(writer.toString());
        }
    }

    public String getDescription(Locale arg0) {
        return "The jQAssistant report.";
    }

    public String getName(Locale arg0) {
        return "jQAssistant";
    }

    public String getOutputName() {
        return "jqassistant";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }
}

