/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.api.iterable.IterableConsumer;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.scm.maven.AbstractAnalysisMojo;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="scan", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class ScanMojo
extends AbstractAnalysisMojo {
    @Override
    protected void aggregate(MavenProject baseProject, Set<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        for (MavenProject project : projects) {
            List scannerPlugins;
            ScannerPluginRepository scannerPluginRepository = this.getScannerPluginRepository(store, this.getPluginProperties(project));
            try {
                scannerPlugins = scannerPluginRepository.getScannerPlugins();
            }
            catch (PluginRepositoryException e) {
                throw new MojoExecutionException("Cannot determine scanner plugins.", (Exception)((Object)e));
            }
            ScannerImpl scanner = new ScannerImpl(scannerPlugins);
            try {
                IterableConsumer.consume((Iterable)scanner.scan((Object)project, project.getFile().getAbsolutePath(), (Scope)MavenScope.PROJECT));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot scan project '" + project.getBasedir() + "'", (Exception)e);
            }
        }
    }

    @Override
    protected boolean isResetStoreOnInitialization() {
        return true;
    }
}

