/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=StoreRepository.class, instantiationStrategy="singleton")
public class StoreRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreRepository.class);
    private Map<File, Store> stores = new HashMap<File, Store>();

    public StoreRepository() {
        LOGGER.info("Initializing store repository.");
    }

    public Store getStore(File directory, boolean reset) {
        Store store = this.stores.get(directory);
        if (store == null) {
            LOGGER.info("Opening store in directory '" + directory.getAbsolutePath() + "'");
            directory.getParentFile().mkdirs();
            store = new EmbeddedGraphStore(directory.getAbsolutePath());
            if (reset) {
                store.start(Collections.emptyList());
                store.reset();
                store.stop();
            }
            this.stores.put(directory, store);
        }
        return store;
    }
}

