/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl;

import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.AnalysisRestService;
import java.util.Arrays;
import java.util.List;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

class JQAServerModule
implements ServerModule {
    public static final String MOUNTPOINT_REST = "/jqa/rest";
    public static final String MOUNTPOINT_STATIC = "/jqa";
    public static final String CONTENT_STATIC = "jqa";
    private WebServer webServer;
    private List<String> jaxRsClassNames;

    JQAServerModule(WebServer webServer) {
        this.webServer = webServer;
        this.jaxRsClassNames = Arrays.asList(AnalysisRestService.class.getName());
    }

    public void start() {
        this.webServer.addStaticContent(CONTENT_STATIC, MOUNTPOINT_STATIC);
        this.webServer.addJAXRSClasses(this.jaxRsClassNames, MOUNTPOINT_REST, null);
    }

    public void stop() {
        this.webServer.removeJAXRSClasses(this.jaxRsClassNames, MOUNTPOINT_REST);
        this.webServer.removeStaticContent(CONTENT_STATIC, MOUNTPOINT_STATIC);
    }
}

