/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl.rest;

import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.RuleSetResolverException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.analysis.impl.RuleSelectorImpl;
import com.buschmais.jqassistant.core.analysis.impl.RuleSetReaderImpl;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.RulePluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.plugin.impl.RulePluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.ScannerPluginRepositoryImpl;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.common.console.Slf4jConsole;
import java.util.Collections;
import java.util.List;

public abstract class AbstractJQARestService {
    private RuleSetReader ruleSetReader;
    private PluginConfigurationReader pluginConfigurationReader;
    private RulePluginRepository rulePluginRepository;
    private Store store = null;

    protected AbstractJQARestService(Store store) throws PluginRepositoryException {
        this.store = store;
        this.pluginConfigurationReader = new PluginConfigurationReaderImpl();
        this.rulePluginRepository = new RulePluginRepositoryImpl(this.pluginConfigurationReader);
        this.ruleSetReader = new RuleSetReaderImpl();
    }

    protected RuleSet getAvailableRules() {
        List ruleSources = this.rulePluginRepository.getRuleSources();
        return this.ruleSetReader.read(ruleSources);
    }

    protected Store getStore() {
        return this.store;
    }

    protected ScannerPluginRepository getScannerPluginRepository() {
        try {
            return new ScannerPluginRepositoryImpl(this.pluginConfigurationReader, this.getStore(), Collections.emptyMap());
        }
        catch (PluginRepositoryException e) {
            throw new IllegalStateException("Cannot get scanner plugin repository", e);
        }
    }

    protected RuleSet getEffectiveRuleSet(List<String> conceptNames, List<String> constraintNames, List<String> groupNames) throws RuleSetResolverException {
        RuleSet availableRules = this.getAvailableRules();
        RuleSelectorImpl ruleSelector = new RuleSelectorImpl();
        return ruleSelector.getEffectiveRuleSet(availableRules, conceptNames, constraintNames, groupNames);
    }

    public InMemoryReportWriter analyze(Store store, List<String> conceptNames, List<String> constraintNames, List<String> groupNames) throws Exception {
        RuleSet effectiveRuleSet = this.getEffectiveRuleSet(conceptNames, constraintNames, groupNames);
        InMemoryReportWriter reportWriter = new InMemoryReportWriter();
        Slf4jConsole console = new Slf4jConsole();
        AnalyzerImpl analyzer = new AnalyzerImpl(store, (AnalysisListener)reportWriter, (Console)console);
        analyzer.execute(effectiveRuleSet);
        ReportHelper reportHelper = new ReportHelper((Console)console);
        reportHelper.verifyConceptResults(reportWriter);
        reportHelper.verifyConstraintViolations(reportWriter);
        return reportWriter;
    }
}

