/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl.rest;

import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.AbstractJQARestService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/analysis")
public class AnalysisRestService
extends AbstractJQARestService {
    public AnalysisRestService(@Context Store store) throws PluginRepositoryException {
        super(store);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/rule")
    public Response getRuleSet() {
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.getAvailableRules()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    @Path(value="/concept")
    public Response runConcept(String conceptId) {
        Store store = this.getStore();
        try {
            store.start((Collection)this.getScannerPluginRepository().getDescriptorTypes());
            InMemoryReportWriter report = this.analyze(store, Arrays.asList(conceptId), Collections.emptyList(), Collections.emptyList());
            int conceptResultSize = report.getConceptResults().size();
            if (conceptResultSize == 0) {
                Response response = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)Integer.toString(conceptResultSize)).build();
            return response;
        }
        catch (Exception e) {
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            store.stop();
        }
    }
}

