/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jshell;

import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.RuleSetResolverException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.impl.RuleSelectorImpl;
import com.buschmais.jqassistant.core.analysis.impl.RuleSetReaderImpl;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.RulePluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.plugin.impl.RulePluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.ScannerPluginRepositoryImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.GraphDbStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.AppShellServer;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

public abstract class AbstractJQAssistantApp
extends AbstractApp {
    private static final Pattern CONCEPTS_PATTERN = Pattern.compile("concepts=(.*)");
    private static final Pattern CONSTRAINTS_PATTERN = Pattern.compile("constraints=(.*)");
    private static final Pattern GROUPS_PATTERN = Pattern.compile("groups=(.*)");
    private PluginConfigurationReader pluginConfigurationReader = new PluginConfigurationReaderImpl();
    private RulePluginRepository rulePluginRepository = new RulePluginRepositoryImpl(this.pluginConfigurationReader);
    private RuleSetReader ruleSetReader = new RuleSetReaderImpl();
    private Store store = null;

    protected AbstractJQAssistantApp() throws PluginRepositoryException {
    }

    public final String getName() {
        return "jqa:" + this.getCommand();
    }

    protected abstract String getCommand();

    protected RuleSet getAvailableRules() {
        List ruleSources = this.rulePluginRepository.getRuleSources();
        return this.ruleSetReader.read(ruleSources);
    }

    protected Store getStore() {
        if (this.store == null) {
            AppShellServer server = this.getServer();
            if (!(server instanceof GraphDatabaseShellServer)) {
                throw new IllegalStateException("Unexpected server type " + server);
            }
            GraphDatabaseAPI db = ((GraphDatabaseShellServer)server).getDb();
            this.store = new GraphDbStore((GraphDatabaseService)db);
        }
        return this.store;
    }

    protected ScannerPluginRepository getScannerPluginRepository() {
        try {
            return new ScannerPluginRepositoryImpl(this.pluginConfigurationReader, this.getStore(), Collections.emptyMap());
        }
        catch (PluginRepositoryException e) {
            throw new IllegalStateException("Cannot get scanner plugin repository", e);
        }
    }

    protected RuleSet getEffectiveRuleSet(AppCommandParser parser) throws RuleSetResolverException {
        ArrayList<String> conceptNames = new ArrayList<String>();
        ArrayList<String> constraintNames = new ArrayList<String>();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (String argument : parser.arguments()) {
            if (this.parseArgument(CONCEPTS_PATTERN, argument, conceptNames) || this.parseArgument(CONSTRAINTS_PATTERN, argument, constraintNames) || this.parseArgument(GROUPS_PATTERN, argument, groupNames)) continue;
            throw new IllegalArgumentException("Illegal argument " + argument);
        }
        RuleSet availableRules = this.getAvailableRules();
        RuleSelectorImpl ruleSelector = new RuleSelectorImpl();
        return ruleSelector.getEffectiveRuleSet(availableRules, conceptNames, constraintNames, groupNames);
    }

    private boolean parseArgument(Pattern pattern, String argument, List<String> values) {
        Matcher matcher = pattern.matcher(argument);
        if (matcher.matches()) {
            values.addAll(Arrays.asList(matcher.group(1).split(",")));
            return true;
        }
        return false;
    }
}

