/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.netscaler.nitro.resource.base;

import com.citrix.netscaler.nitro.exception.nitro_exception;
import com.citrix.netscaler.nitro.resource.base.EmptyHostnameVerifier;
import com.citrix.netscaler.nitro.resource.base.EmptyTrustManager;
import com.citrix.netscaler.nitro.resource.base.base_response;
import com.citrix.netscaler.nitro.resource.base.base_responses;
import com.citrix.netscaler.nitro.service.nitro_service;
import com.citrix.netscaler.nitro.service.options;
import com.citrix.netscaler.nitro.util.nitro_util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public abstract class base_resource {
    protected abstract base_resource[] get_nitro_response(nitro_service var1, String var2) throws Exception;

    protected abstract String get_object_name();

    protected String get_object_type() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(".");
        if (index > 0) {
            name = name.substring(index + 1);
        }
        if ((index = name.lastIndexOf("_stats")) > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    protected String resource_to_string(nitro_service service2, String id, options option) {
        Boolean warning = service2.get_warning();
        String onerror = service2.get_onerror();
        String result = service2.get_payload_formatter().resource_to_string(this, id, option, warning, onerror);
        return result;
    }

    protected String resource_to_string(nitro_service service2) {
        String result = service2.get_payload_formatter().resource_to_string(this);
        return result;
    }

    protected String unset_string(nitro_service service2, String id, options option, String[] args) throws Exception {
        Boolean warning = service2.get_warning();
        String result = service2.get_payload_formatter().unset_string(this, id, option, args, warning);
        return result;
    }

    private base_resource post_requestEx(nitro_service service2, options option) throws Exception {
        String sessionid = service2.get_sessionid();
        String request = this.resource_to_string(service2, sessionid, option);
        return this.post_dataEx(service2, request);
    }

    private base_response post_request(nitro_service service2, options option) throws Exception {
        String sessionid = service2.get_sessionid();
        String request = this.resource_to_string(service2, sessionid, option);
        return base_resource.post_data(service2, request);
    }

    private base_response unset_request(nitro_service service2, options option, String[] args) throws Exception {
        String sessionid = service2.get_sessionid();
        String request = this.unset_string(service2, sessionid, option, args);
        return base_resource.post_data(service2, request);
    }

    protected base_response add_resource(nitro_service service2) throws Exception {
        return this.add_resource(service2, null);
    }

    protected base_response add_resource(nitro_service service2, options option) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        String sessionid = service2.get_sessionid();
        String request = this.resource_to_string(service2, sessionid, option);
        return base_resource.post_data(service2, request);
    }

    protected base_response update_resource(nitro_service service2) throws Exception {
        return this.update_resource(service2, null);
    }

    protected base_response update_resource(nitro_service service2, options option) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        String sessionid = service2.get_sessionid();
        String request = this.resource_to_string(service2, sessionid, option);
        return base_resource.put_data(service2, request);
    }

    protected base_response delete_resource(nitro_service service2) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        String str = nitro_util.object_to_string_withoutquotes(this);
        base_response response = this.delete_request(service2, str);
        return response;
    }

    protected base_resource[] getfiltered(nitro_service service2, options option) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        base_resource[] response = this.get_request(service2, option);
        return response;
    }

    protected base_resource[] get_resources(nitro_service service2, options option) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        base_resource[] response = this.get_request(service2, option);
        return response;
    }

    protected base_resource[] get_resources(nitro_service service2) throws Exception {
        return this.get_resources(service2, null);
    }

    protected base_resource get_resource(nitro_service service2, options option) throws Exception {
        base_resource[] response;
        if (!service2.isLogin()) {
            service2.login();
        }
        if ((response = this.get_request(service2, option)) != null) {
            return response[0];
        }
        return null;
    }

    protected base_resource get_resource(nitro_service service2) throws Exception {
        return this.get_resource(service2, null);
    }

    protected base_resource[] stat_resources(nitro_service service2, options option) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        base_resource[] response = this.stat_request(service2, option);
        return response;
    }

    protected base_resource[] stat_resources(nitro_service service2) throws Exception {
        return this.stat_resources(service2, null);
    }

    protected base_resource stat_resource(nitro_service service2, options option) throws Exception {
        base_resource[] response;
        if (!service2.isLogin()) {
            service2.login();
        }
        if ((response = this.stat_request(service2, option)) != null && response.length > 0) {
            return response[0];
        }
        return null;
    }

    protected base_resource stat_resource(nitro_service service2) throws Exception {
        return this.stat_resource(service2, null);
    }

    public base_response perform_operation(nitro_service service2, String action) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        options option = new options();
        option.set_action(action);
        base_response response = this.post_request(service2, option);
        return response;
    }

    public base_resource perform_operationEx(nitro_service service2, String action) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        options option = new options();
        option.set_action(action);
        base_resource response = this.post_requestEx(service2, option);
        return response;
    }

    public base_response perform_operation(nitro_service service2) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        base_response response = this.post_request(service2, null);
        return response;
    }

    public base_response perform_operation(nitro_service service2, options option) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        base_response response = this.post_request(service2, option);
        return response;
    }

    protected static base_responses perform_operation_bulk_request(nitro_service service2, base_resource[] resources, String action) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        options option = new options();
        option.set_action(action);
        String onerror = service2.get_onerror();
        Boolean warning = service2.get_warning();
        String id = service2.get_sessionid();
        String request = service2.get_payload_formatter().resource_to_string(resources, id, option, warning, onerror);
        base_responses result = base_resource.post_bulk_data(service2, request);
        return result;
    }

    protected void set_newname(String newname) throws Exception {
        nitro_exception e = new nitro_exception("Rename is not supported for this resource", -1);
        throw e;
    }

    protected base_response rename_resource(nitro_service service2, String newname) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        options option = new options();
        option.set_action("rename");
        this.set_newname(newname);
        base_response response = this.post_request(service2, option);
        return response;
    }

    protected base_response unset_resource(nitro_service service2, String[] args) throws Exception {
        if (!service2.isLogin() && !this.get_object_type().equals("login")) {
            service2.login();
        }
        options option = new options();
        option.set_action("unset");
        base_response response = this.unset_request(service2, option, args);
        return response;
    }

    protected static base_responses update_bulk_request(nitro_service service2, base_resource[] resources) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        String id = service2.get_sessionid();
        Boolean warning = service2.get_warning();
        String onerror = service2.get_onerror();
        String request = service2.get_payload_formatter().resource_to_string(resources, id, null, warning, onerror);
        base_responses result = base_resource.put_bulk_data(service2, request);
        return result;
    }

    protected static base_responses unset_bulk_request(nitro_service service2, base_resource[] resources, String[] args) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        String id = service2.get_sessionid();
        options option = new options();
        option.set_action("unset");
        String onerror = service2.get_onerror();
        Boolean warning = service2.get_warning();
        String request = service2.get_payload_formatter().unset_string(resources, id, option, args, warning, onerror);
        return base_resource.post_bulk_data(service2, request);
    }

    protected static base_responses add_bulk_request(nitro_service service2, base_resource[] resources) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        String id = service2.get_sessionid();
        String onerror = service2.get_onerror();
        Boolean warning = service2.get_warning();
        String request = service2.get_payload_formatter().resource_to_string(resources, id, null, warning, onerror);
        base_responses result = base_resource.post_bulk_data(service2, request);
        return result;
    }

    protected static base_responses delete_bulk_request(nitro_service service2, base_resource[] resources) throws Exception {
        if (!service2.isLogin()) {
            service2.login();
        }
        options option = new options();
        option.set_action("rm");
        String type = resources[0].get_object_type();
        if (type.indexOf("_binding") > 0) {
            option.set_action("unbind");
        }
        String id = service2.get_sessionid();
        String onerror = service2.get_onerror();
        Boolean warning = service2.get_warning();
        String request = service2.get_payload_formatter().resource_to_string(resources, id, option, warning, onerror);
        base_responses result = base_resource.post_bulk_data(service2, request);
        return result;
    }

    private static String _put(nitro_service service2, String request) throws Exception {
        StringBuilder responseStr = new StringBuilder();
        try {
            int numOfTotalBytesRead;
            InputStream input;
            String ipaddress = service2.get_ipaddress();
            String version = service2.get_version();
            String protocol = service2.get_protocol();
            String urlstr = protocol + "://" + ipaddress + "/nitro/" + version + "/config/";
            URL url = new URL(urlstr);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("PUT");
            if (httpURLConnection instanceof HttpsURLConnection) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new EmptyTrustManager()}, null);
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection secured = (HttpsURLConnection)httpURLConnection;
                secured.setSSLSocketFactory(sslSocketFactory);
                secured.setHostnameVerifier(new EmptyHostnameVerifier());
            }
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setDoOutput(true);
            OutputStreamWriter ouput = new OutputStreamWriter(httpURLConnection.getOutputStream());
            ouput.write(request);
            ouput.flush();
            ouput.close();
            try {
                input = httpURLConnection.getInputStream();
            }
            catch (Exception e) {
                input = httpURLConnection.getErrorStream();
            }
            String contentEncoding = httpURLConnection.getContentEncoding();
            if (contentEncoding != null) {
                if (contentEncoding.equalsIgnoreCase("gzip")) {
                    input = new GZIPInputStream(input);
                } else if (contentEncoding.equalsIgnoreCase("deflate")) {
                    input = new InflaterInputStream(input);
                }
            }
            byte[] buffer = new byte[1024];
            while ((numOfTotalBytesRead = input.read(buffer, 0, buffer.length)) != -1) {
                responseStr.append(new String(buffer, 0, numOfTotalBytesRead));
            }
            httpURLConnection.disconnect();
            input.close();
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        return responseStr.toString();
    }

    private static base_response put_data(nitro_service service2, String request) throws Exception {
        String response = base_resource._put(service2, request);
        base_response result = (base_response)service2.get_payload_formatter().string_to_resource(base_response.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service2.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result;
    }

    private static base_responses put_bulk_data(nitro_service service2, String request) throws Exception {
        String response = base_resource._put(service2, request);
        base_responses result = (base_responses)service2.get_payload_formatter().string_to_resource(base_responses.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service2.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode, result.response);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode, result.response);
            }
        }
        return result;
    }

    private static String _post(nitro_service service2, String request) throws Exception {
        StringBuilder responseStr = new StringBuilder();
        try {
            int numOfTotalBytesRead;
            InputStream input;
            String ipaddress = service2.get_ipaddress();
            String version = service2.get_version();
            String protocol = service2.get_protocol();
            String urlstr = protocol + "://" + ipaddress + "/nitro/" + version + "/config/";
            URL url = new URL(urlstr);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            if (httpURLConnection instanceof HttpsURLConnection) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new EmptyTrustManager()}, null);
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection secured = (HttpsURLConnection)httpURLConnection;
                secured.setSSLSocketFactory(sslSocketFactory);
                secured.setHostnameVerifier(new EmptyHostnameVerifier());
            }
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            request = nitro_util.encode(request);
            request = "object=" + request;
            OutputStreamWriter ouput = new OutputStreamWriter(httpURLConnection.getOutputStream());
            ouput.write(request);
            ouput.flush();
            ouput.close();
            try {
                input = httpURLConnection.getInputStream();
            }
            catch (Exception e) {
                input = httpURLConnection.getErrorStream();
            }
            String contentEncoding = httpURLConnection.getContentEncoding();
            if (contentEncoding != null) {
                if (contentEncoding.equalsIgnoreCase("gzip")) {
                    input = new GZIPInputStream(input);
                } else if (contentEncoding.equalsIgnoreCase("deflate")) {
                    input = new InflaterInputStream(input);
                }
            }
            byte[] buffer = new byte[1024];
            while ((numOfTotalBytesRead = input.read(buffer, 0, buffer.length)) != -1) {
                responseStr.append(new String(buffer, 0, numOfTotalBytesRead));
            }
            input.close();
            httpURLConnection.disconnect();
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        return responseStr.toString();
    }

    private base_resource post_dataEx(nitro_service service2, String request) throws Exception {
        String response = base_resource._post(service2, request);
        base_resource[] result = this.get_nitro_response(service2, response);
        return result[0];
    }

    private static base_response post_data(nitro_service service2, String request) throws Exception {
        String response = base_resource._post(service2, request);
        base_response result = (base_response)service2.get_payload_formatter().string_to_resource(base_response.class, response);
        if (result.errorcode != 0 && result.errorcode != 1034) {
            if (result.errorcode == 444) {
                service2.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result;
    }

    private static base_responses post_bulk_data(nitro_service service2, String request) throws Exception {
        String response = base_resource._post(service2, request);
        base_responses result = (base_responses)service2.get_payload_formatter().string_to_resource(base_responses.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service2.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode, result.response);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode, result.response);
            }
        }
        return result;
    }

    private base_resource[] get_request(nitro_service service2, options option) throws Exception {
        StringBuilder responseStr = new StringBuilder();
        HttpURLConnection httpURLConnection = null;
        try {
            int numOfTotalBytesRead;
            InputStream input;
            String ipaddress = service2.get_ipaddress();
            String version = service2.get_version();
            String sessionid = service2.get_sessionid();
            String objtype = this.get_object_type();
            String protocol = service2.get_protocol();
            String urlstr = protocol + "://" + ipaddress + "/nitro/" + version + "/config/" + objtype;
            String name = this.get_object_name();
            if (name != null && name.length() > 0) {
                urlstr = urlstr + "/" + nitro_util.encode(nitro_util.encode(name));
            }
            if (option != null || service2.get_warning() != null && service2.get_warning().booleanValue()) {
                String optionstr = null;
                if (option != null && (optionstr = option.to_string()).length() > 0) {
                    urlstr = urlstr + "?";
                    urlstr = urlstr + optionstr;
                }
                if (service2.get_warning() != null && service2.get_warning().booleanValue()) {
                    urlstr = option != null && optionstr.length() > 0 ? urlstr + "&" : urlstr + "?";
                    urlstr = urlstr + "warning=yes";
                }
            }
            URL url = new URL(urlstr);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Cookie", "sessionid=" + nitro_util.encode(sessionid));
            if (option != null && option.get_compression()) {
                httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            if (httpURLConnection instanceof HttpsURLConnection) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new EmptyTrustManager()}, null);
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection secured = (HttpsURLConnection)httpURLConnection;
                secured.setSSLSocketFactory(sslSocketFactory);
                secured.setHostnameVerifier(new EmptyHostnameVerifier());
            }
            try {
                input = httpURLConnection.getInputStream();
            }
            catch (Exception e) {
                input = httpURLConnection.getErrorStream();
            }
            String contentEncoding = httpURLConnection.getContentEncoding();
            if (contentEncoding != null) {
                if (contentEncoding.equalsIgnoreCase("gzip")) {
                    input = new GZIPInputStream(input);
                } else if (contentEncoding.equalsIgnoreCase("deflate")) {
                    input = new InflaterInputStream(input);
                }
            }
            byte[] buffer = new byte[1024];
            while ((numOfTotalBytesRead = input.read(buffer, 0, buffer.length)) != -1) {
                responseStr.append(new String(buffer, 0, numOfTotalBytesRead));
            }
            httpURLConnection.disconnect();
            input.close();
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        base_resource[] result = this.get_nitro_response(service2, responseStr.toString());
        return result;
    }

    private base_resource[] stat_request(nitro_service service2, options option) throws Exception {
        StringBuilder responseStr = new StringBuilder();
        HttpURLConnection httpURLConnection = null;
        try {
            int numOfTotalBytesRead;
            InputStream input;
            String ipaddress = service2.get_ipaddress();
            String version = service2.get_version();
            String sessionid = service2.get_sessionid();
            String objtype = this.get_object_type();
            String protocol = service2.get_protocol();
            String urlstr = protocol + "://" + ipaddress + "/nitro/" + version + "/stat/" + objtype;
            String name = this.get_object_name();
            if (name != null && name.length() > 0) {
                urlstr = urlstr + "/" + nitro_util.encode(nitro_util.encode(name));
            }
            if (option != null || service2.get_warning() != null && service2.get_warning().booleanValue()) {
                String optionstr = null;
                if (option != null && (optionstr = option.to_string()).length() > 0) {
                    urlstr = urlstr + "?";
                    urlstr = urlstr + optionstr;
                }
                if (service2.get_warning() != null && service2.get_warning().booleanValue()) {
                    urlstr = option != null && optionstr.length() > 0 ? urlstr + "&" : urlstr + "?";
                    urlstr = urlstr + "warning=yes";
                }
            }
            URL url = new URL(urlstr);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Cookie", "sessionid=" + nitro_util.encode(sessionid));
            if (option != null && option.get_compression()) {
                httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            if (httpURLConnection instanceof HttpsURLConnection) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new EmptyTrustManager()}, null);
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection secured = (HttpsURLConnection)httpURLConnection;
                secured.setSSLSocketFactory(sslSocketFactory);
                secured.setHostnameVerifier(new EmptyHostnameVerifier());
            }
            try {
                input = httpURLConnection.getInputStream();
            }
            catch (Exception e) {
                input = httpURLConnection.getErrorStream();
            }
            String contentEncoding = httpURLConnection.getContentEncoding();
            if (contentEncoding != null) {
                if (contentEncoding.equalsIgnoreCase("gzip")) {
                    input = new GZIPInputStream(input);
                } else if (contentEncoding.equalsIgnoreCase("deflate")) {
                    input = new InflaterInputStream(input);
                }
            }
            byte[] buffer = new byte[1024];
            while ((numOfTotalBytesRead = input.read(buffer, 0, buffer.length)) != -1) {
                responseStr.append(new String(buffer, 0, numOfTotalBytesRead));
            }
            httpURLConnection.disconnect();
            input.close();
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        base_resource[] result = this.get_nitro_response(service2, responseStr.toString());
        return result;
    }

    private base_response delete_request(nitro_service service2, String req_args) throws Exception {
        StringBuilder responseStr = new StringBuilder();
        HttpURLConnection httpURLConnection = null;
        try {
            int numOfTotalBytesRead;
            InputStream input;
            String ipaddress = service2.get_ipaddress();
            String version = service2.get_version();
            String sessionid = service2.get_sessionid();
            String objtype = this.get_object_type();
            String protocol = service2.get_protocol();
            String urlstr = protocol + "://" + ipaddress + "/nitro/" + version + "/config/" + objtype;
            String name = this.get_object_name();
            if (name != null && name.length() > 0) {
                urlstr = urlstr + "/" + nitro_util.encode(nitro_util.encode(name));
            }
            if (req_args != null || service2.get_warning() != null && service2.get_warning().booleanValue()) {
                urlstr = urlstr + "?";
                if (req_args != null) {
                    urlstr = urlstr + "args=" + req_args;
                }
                if (service2.get_warning() != null && service2.get_warning().booleanValue()) {
                    if (req_args != null) {
                        urlstr = urlstr + "&";
                    }
                    urlstr = urlstr + "warning=yes";
                }
            }
            URL url = new URL(urlstr);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("DELETE");
            httpURLConnection.setRequestProperty("Cookie", "sessionid=" + nitro_util.encode(sessionid));
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            if (httpURLConnection instanceof HttpsURLConnection) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new EmptyTrustManager()}, null);
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection secured = (HttpsURLConnection)httpURLConnection;
                secured.setSSLSocketFactory(sslSocketFactory);
                secured.setHostnameVerifier(new EmptyHostnameVerifier());
            }
            try {
                input = httpURLConnection.getInputStream();
            }
            catch (Exception e) {
                input = httpURLConnection.getErrorStream();
            }
            String contentEncoding = httpURLConnection.getContentEncoding();
            if (contentEncoding != null) {
                if (contentEncoding.equalsIgnoreCase("gzip")) {
                    input = new GZIPInputStream(input);
                } else if (contentEncoding.equalsIgnoreCase("deflate")) {
                    input = new InflaterInputStream(input);
                }
            }
            byte[] buffer = new byte[1024];
            while ((numOfTotalBytesRead = input.read(buffer, 0, buffer.length)) != -1) {
                responseStr.append(new String(buffer, 0, numOfTotalBytesRead));
            }
            httpURLConnection.disconnect();
            input.close();
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        base_response result = (base_response)service2.get_payload_formatter().string_to_resource(base_response.class, responseStr.toString());
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service2.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result;
    }
}

