/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.netscaler.nitro.service;

import com.citrix.netscaler.nitro.exception.nitro_exception;
import com.citrix.netscaler.nitro.resource.base.Json;
import com.citrix.netscaler.nitro.resource.base.base_response;
import com.citrix.netscaler.nitro.resource.base.ipayload_formatter;
import com.citrix.netscaler.nitro.resource.base.login;
import com.citrix.netscaler.nitro.resource.base.loginchallengeresponse;
import com.citrix.netscaler.nitro.resource.base.logout;
import com.citrix.netscaler.nitro.resource.config.ha.hafailover;
import com.citrix.netscaler.nitro.resource.config.ha.hasync;
import com.citrix.netscaler.nitro.resource.config.ns.nsconfig;
import com.citrix.netscaler.nitro.resource.config.ns.nsfeature;
import com.citrix.netscaler.nitro.resource.config.ns.nsmode;
import com.citrix.netscaler.nitro.resource.config.ns.reboot;
import com.citrix.netscaler.nitro.service.options;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class nitro_service {
    private String user_name;
    private String password;
    private String ipaddress;
    private String version;
    private String sessionid;
    private String protocol;
    private Boolean warning;
    private ipayload_formatter format;
    private Long timeout;
    private OnerrorEnum onerror;

    public nitro_service(String ip) throws nitro_exception {
        this(ip, new Json(), "http");
    }

    public nitro_service(String ip, String protocol) throws nitro_exception {
        this(ip, new Json(), protocol);
    }

    public nitro_service(String ip, ipayload_formatter format) throws nitro_exception {
        this(ip, format, "http");
    }

    public nitro_service(String ip, ipayload_formatter format, String protocol) throws nitro_exception {
        if (protocol == null || !protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            throw new nitro_exception("error: protocol value " + protocol + " is not supported");
        }
        this.ipaddress = ip;
        this.version = "v1";
        this.protocol = protocol;
        this.format = format;
        if (this.format == null) {
            this.format = new Json();
        }
    }

    public void set_credential(String username, String password) {
        this.user_name = username;
        this.password = password;
    }

    public void set_timeout(long timeout) {
        this.timeout = new Long(timeout);
    }

    public void set_timeout(Long timeout) {
        this.timeout = timeout;
    }

    public void set_warning(Boolean warning) {
        this.warning = warning;
    }

    public Boolean get_warning() {
        return this.warning;
    }

    public boolean isLogin() {
        return this.sessionid != null;
    }

    public String get_ipaddress() {
        return this.ipaddress;
    }

    public String get_onerror() {
        if (this.onerror != null) {
            return this.onerror.toString();
        }
        return "";
    }

    public void set_onerror(OnerrorEnum onerror) {
        this.onerror = onerror;
    }

    public String get_version() {
        return this.version;
    }

    public String get_sessionid() {
        return this.sessionid;
    }

    public base_response login() throws Exception {
        login login2 = new login(this.user_name, this.password, this.timeout);
        base_response result = login2.perform_operation(this);
        if (result.errorcode == 0 || result.errorcode == 1034) {
            this.sessionid = result.sessionid;
        }
        return result;
    }

    public base_response loginchallengeresponse(String response) throws Exception {
        loginchallengeresponse logincr = new loginchallengeresponse(response);
        base_response result = logincr.perform_operation(this);
        if (result.errorcode == 0) {
            this.sessionid = result.sessionid;
        }
        return result;
    }

    public base_response reboot(boolean warm) throws Exception {
        reboot resource = new reboot();
        resource.set_warm(warm);
        base_response result = resource.perform_operation(this);
        return result;
    }

    public base_response forcehasync(Boolean force, String save) throws Exception {
        hasync resource = new hasync();
        resource.set_force(force);
        resource.set_save(save);
        options option = new options();
        option.set_action("force");
        base_response result = resource.perform_operation(this, option);
        return result;
    }

    public base_response forcehafailover(Boolean force) throws Exception {
        hafailover resource = new hafailover();
        resource.set_force(force);
        options option = new options();
        option.set_action("force");
        base_response result = resource.perform_operation(this, option);
        return result;
    }

    public base_response clear_config() throws Exception {
        return this.clear_config(true, "basic");
    }

    public base_response clear_config(Boolean force) throws Exception {
        return this.clear_config(force, "basic");
    }

    public base_response clear_config(Boolean force, String level) throws Exception {
        base_response result = null;
        nsconfig resource = new nsconfig();
        if (force.booleanValue()) {
            resource.set_force(force);
        }
        resource.set_level(level);
        options option = new options();
        option.set_action("clear");
        result = resource.perform_operation(this, option);
        return result;
    }

    public base_response save_config() throws Exception {
        nsconfig resource = new nsconfig();
        options option = new options();
        option.set_action("save");
        base_response result = resource.perform_operation(this, option);
        return result;
    }

    public String[] get_features() throws Exception {
        Method[] methods;
        int counter = 0;
        ArrayList<String> features = new ArrayList<String>();
        String prefix = "get_";
        for (Method method : methods = nsfeature.class.getDeclaredMethods()) {
            String returntype_name;
            String method_name = method.getName();
            if (!method_name.startsWith(prefix) || method_name.equals("get_object_name") || !(returntype_name = method.getReturnType().getName()).equals("java.lang.Boolean")) continue;
            String feature_name = method_name.substring(prefix.length());
            features.add(feature_name);
            ++counter;
        }
        String[] strArr = new String[counter];
        return features.toArray(strArr);
    }

    public String[] get_enabled_features() throws Exception {
        ArrayList<String> features = new ArrayList<String>();
        String prefix = "get_";
        int counter = 0;
        Method[] methods = nsfeature.class.getDeclaredMethods();
        nsfeature feature = nsfeature.get(this);
        for (Method method : methods) {
            Method methd;
            Boolean value;
            String returntype_name;
            String method_name = method.getName();
            if (!method_name.startsWith(prefix) || method_name.equals("get_object_name") || !(returntype_name = method.getReturnType().getName()).equals("java.lang.Boolean") || (value = (Boolean)(methd = nsfeature.class.getMethod(method_name, null)).invoke((Object)feature, (Object[])new Class[0])) == null || !value.booleanValue()) continue;
            String feature_name = method_name.substring(prefix.length());
            features.add(feature_name);
            ++counter;
        }
        String[] strArr = new String[counter];
        return features.toArray(strArr);
    }

    public base_response enable_features(String[] features) throws Exception {
        base_response result = null;
        nsfeature resource = new nsfeature();
        resource.set_feature(features);
        options option = new options();
        option.set_action("enable");
        result = resource.perform_operation(this, option);
        return result;
    }

    public base_response disable_features(String[] features) throws Exception {
        base_response result = null;
        nsfeature resource = new nsfeature();
        resource.set_feature(features);
        options option = new options();
        option.set_action("disable");
        result = resource.perform_operation(this, option);
        return result;
    }

    public String[] get_modes() throws Exception {
        Method[] methods;
        int counter = 0;
        ArrayList<String> modes = new ArrayList<String>();
        String prefix = "get_";
        for (Method method : methods = nsmode.class.getDeclaredMethods()) {
            String returntype_name;
            String method_name = method.getName();
            if (!method_name.startsWith(prefix) || method_name.equals("get_object_name") || !(returntype_name = method.getReturnType().getName()).equals("java.lang.Boolean")) continue;
            String mode_name = method_name.substring(prefix.length());
            modes.add(mode_name);
            ++counter;
        }
        String[] strArr = new String[counter];
        return modes.toArray(strArr);
    }

    public String[] get_enabled_modes() throws Exception {
        ArrayList<String> modes = new ArrayList<String>();
        String prefix = "get_";
        int counter = 0;
        Method[] methods = nsmode.class.getDeclaredMethods();
        nsmode mode = nsmode.get(this);
        for (Method method : methods) {
            Method methd;
            Boolean value;
            String returntype_name;
            String method_name = method.getName();
            if (!method_name.startsWith(prefix) || method_name.equals("get_object_name") || !(returntype_name = method.getReturnType().getName()).equals("java.lang.Boolean") || (value = (Boolean)(methd = nsmode.class.getMethod(method_name, null)).invoke((Object)mode, (Object[])new Class[0])) == null || !value.booleanValue()) continue;
            String mode_name = method_name.substring(prefix.length());
            modes.add(mode_name);
            ++counter;
        }
        String[] strArr = new String[counter];
        return modes.toArray(strArr);
    }

    public base_response enable_modes(String[] modes) throws Exception {
        base_response result = null;
        nsmode resource = new nsmode();
        resource.set_mode(modes);
        options option = new options();
        option.set_action("enable");
        result = resource.perform_operation(this, option);
        return result;
    }

    public base_response disable_modes(String[] modes) throws Exception {
        base_response result = null;
        nsmode resource = new nsmode();
        resource.set_mode(modes);
        options option = new options();
        option.set_action("disable");
        result = resource.perform_operation(this, option);
        return result;
    }

    public void clear_session() {
        this.sessionid = null;
    }

    public base_response relogin() throws Exception {
        this.sessionid = null;
        return this.login();
    }

    public base_response login(String username, String password) throws Exception {
        this.set_credential(username, password);
        return this.login();
    }

    public base_response login(String username, String password, Long timeout) throws Exception {
        this.set_credential(username, password);
        this.set_timeout(timeout);
        return this.login();
    }

    public base_response logout() throws Exception {
        base_response result = null;
        logout logout2 = new logout();
        result = logout2.perform_operation(this);
        this.sessionid = null;
        this.user_name = null;
        this.password = null;
        return result;
    }

    public String get_protocol() {
        return this.protocol;
    }

    public void set_protocol(String protocol) throws nitro_exception {
        if (protocol == null || !protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            throw new nitro_exception("error: protocol value " + protocol + " is not supported");
        }
        this.protocol = protocol;
    }

    public ipayload_formatter get_payload_formatter() {
        return this.format;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnerrorEnum {
        EXIT,
        CONTINUE,
        ROLLBACK;

    }
}

