/*
* Copyright (c) 2008-2015 Citrix Systems, Inc.
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*/

package com.citrix.netscaler.nitro.resource.stat.protocol;

import com.citrix.netscaler.nitro.resource.base.*;
import com.citrix.netscaler.nitro.service.nitro_service;
import com.citrix.netscaler.nitro.service.options;
import com.citrix.netscaler.nitro.util.*;
import com.citrix.netscaler.nitro.exception.nitro_exception;

class protocolicmp_response extends base_response
{
	public protocolicmp_stats protocolicmp;
}
/**
* Statistics for icmp resource.
*/

public class protocolicmp_stats extends base_resource
{
	private String clearstats;
	private Long icmptotrxpkts;
	private Long icmprxpktsrate;
	private Long icmptotrxbytes;
	private Long icmprxbytesrate;
	private Long icmptottxpkts;
	private Long icmptxpktsrate;
	private Long icmptottxbytes;
	private Long icmptxbytesrate;
	private Long icmptotrxechoreply;
	private Long icmprxechoreplyrate;
	private Long icmptottxechoreply;
	private Long icmptxechoreplyrate;
	private Long icmptotrxecho;
	private Long icmprxechorate;
	private Long icmptotdstiplookup;
	private Long icmpcurratethreshold;
	private Long icmptotportunreachablerx;
	private Long icmptotportunreachabletx;
	private Long icmptotneedfragrx;
	private Long icmptotthresholdexceeds;
	private Long icmptotpktsdropped;
	private Long icmptotbadchecksum;
	private Long icmptotnonfirstipfrag;
	private Long icmptotinvalidbodylen;
	private Long icmptotnotcpconn;
	private Long icmptotnoudpconn;
	private Long icmptotinvalidtcpseqno;
	private Long icmptotinvalidnextmtuval;
	private Long icmptotbignextmtu;
	private Long icmptotinvalidprotocol;
	private Long icmptotbadpmtuipchecksum;
	private Long icmptotpmtunolink;
	private Long icmptotpmtudiscoverydisabled;

	/**
	* <pre>
	* Clear the statsistics / counters
	* </pre>
	*/
	public void set_clearstats(String clearstats) throws Exception{
		this.clearstats = clearstats;
	}

	/**
	* <pre>
	* Clear the statsistics / counters.<br> Possible values = basic, full
	* </pre>
	*/
	public String get_clearstats() throws Exception {
		return this.clearstats;
	}

	/**
	* <pre>
	* Rate (/s) counter for icmptotrxbytes
	* </pre>
	*/
	public Long get_icmprxbytesrate() throws Exception {
		return this.icmprxbytesrate;
	}

	/**
	* <pre>
	* ICMP packets dropped because the rate threshold has been exceeded.
	* </pre>
	*/
	public Long get_icmptotpktsdropped() throws Exception {
		return this.icmptotpktsdropped;
	}

	/**
	* <pre>
	* ICMP Ping echo replies received.
	* </pre>
	*/
	public Long get_icmptotrxechoreply() throws Exception {
		return this.icmptotrxechoreply;
	}

	/**
	* <pre>
	* Times the ICMP rate threshold is exceeded. If this counter continuously increases, first make sure the ICMP packets received are genuine. If they are, increase the current rate threshold.
	* </pre>
	*/
	public Long get_icmptotthresholdexceeds() throws Exception {
		return this.icmptotthresholdexceeds;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received with an IP checksum error.
	* </pre>
	*/
	public Long get_icmptotbadpmtuipchecksum() throws Exception {
		return this.icmptotbadpmtuipchecksum;
	}

	/**
	* <pre>
	* Rate (/s) counter for icmptotrxechoreply
	* </pre>
	*/
	public Long get_icmprxechoreplyrate() throws Exception {
		return this.icmprxechoreplyrate;
	}

	/**
	* <pre>
	* Rate (/s) counter for icmptottxpkts
	* </pre>
	*/
	public Long get_icmptxpktsrate() throws Exception {
		return this.icmptxpktsrate;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received with an ICMP checksum error.
	* </pre>
	*/
	public Long get_icmptotbadchecksum() throws Exception {
		return this.icmptotbadchecksum;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received that were generated by an IP fragment other than the first one.
	* </pre>
	*/
	public Long get_icmptotnonfirstipfrag() throws Exception {
		return this.icmptotnonfirstipfrag;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received that specified an invalid body length.
	* </pre>
	*/
	public Long get_icmptotinvalidbodylen() throws Exception {
		return this.icmptotinvalidbodylen;
	}

	/**
	* <pre>
	* ICMP Ping echo replies transmitted.
	* </pre>
	*/
	public Long get_icmptottxechoreply() throws Exception {
		return this.icmptottxechoreply;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received on a Protocol Control Block (PCB) with no link. The PCB maintains the state of the connection.
	* </pre>
	*/
	public Long get_icmptotpmtunolink() throws Exception {
		return this.icmptotpmtunolink;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received that contain a protocol other than TCP and UDP.
	* </pre>
	*/
	public Long get_icmptotinvalidprotocol() throws Exception {
		return this.icmptotinvalidprotocol;
	}

	/**
	* <pre>
	* ICMP packets transmitted.
	* </pre>
	*/
	public Long get_icmptottxpkts() throws Exception {
		return this.icmptottxpkts;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received in which the Maximum Transmission Unit (MTU) for the next hop is out of range. The range for the MTU is 576-1500.
	* </pre>
	*/
	public Long get_icmptotinvalidnextmtuval() throws Exception {
		return this.icmptotinvalidnextmtuval;
	}

	/**
	* <pre>
	* ICMP Port Unreachable error messages received. This error is generated when there is no service is running on the port.
	* </pre>
	*/
	public Long get_icmptotportunreachablerx() throws Exception {
		return this.icmptotportunreachablerx;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received for packets that need to be fragmented but for which Don't Fragment is specified the header.
	* </pre>
	*/
	public Long get_icmptotneedfragrx() throws Exception {
		return this.icmptotneedfragrx;
	}

	/**
	* <pre>
	* ICMP Ping Echo Request and Echo Reply packets received.
	* </pre>
	*/
	public Long get_icmptotrxecho() throws Exception {
		return this.icmptotrxecho;
	}

	/**
	* <pre>
	* Total number of MTU lookup on destination IP info received on a need fragmentation ICMP error message failed.
	* </pre>
	*/
	public Long get_icmptotdstiplookup() throws Exception {
		return this.icmptotdstiplookup;
	}

	/**
	* <pre>
	* Rate (/s) counter for icmptotrxecho
	* </pre>
	*/
	public Long get_icmprxechorate() throws Exception {
		return this.icmprxechorate;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received in which the value for the next MTU is higher than that of the current MTU.
	* </pre>
	*/
	public Long get_icmptotbignextmtu() throws Exception {
		return this.icmptotbignextmtu;
	}

	/**
	* <pre>
	* Rate (/s) counter for icmptottxechoreply
	* </pre>
	*/
	public Long get_icmptxechoreplyrate() throws Exception {
		return this.icmptxechoreplyrate;
	}

	/**
	* <pre>
	* ICMP Need Fragmentation error messages received when the PMTU Discovery mode is not enabled.
	* </pre>
	*/
	public Long get_icmptotpmtudiscoverydisabled() throws Exception {
		return this.icmptotpmtudiscoverydisabled;
	}

	/**
	* <pre>
	* Rate (/s) counter for icmptotrxpkts
	* </pre>
	*/
	public Long get_icmprxpktsrate() throws Exception {
		return this.icmprxpktsrate;
	}

	/**
	* <pre>
	* ICMP Need Fragmentation error messages received for UDP packets. The state of the connection for these packets is not maintained on the NetScaler.
	* </pre>
	*/
	public Long get_icmptotnoudpconn() throws Exception {
		return this.icmptotnoudpconn;
	}

	/**
	* <pre>
	* Bytes of ICMP data transmitted.
	* </pre>
	*/
	public Long get_icmptottxbytes() throws Exception {
		return this.icmptottxbytes;
	}

	/**
	* <pre>
	* Bytes of ICMP data received.
	* </pre>
	*/
	public Long get_icmptotrxbytes() throws Exception {
		return this.icmptotrxbytes;
	}

	/**
	* <pre>
	* ICMP packets received.
	* </pre>
	*/
	public Long get_icmptotrxpkts() throws Exception {
		return this.icmptotrxpkts;
	}

	/**
	* <pre>
	* ICMP Port Unreachable error messages generated. This error is generated when there is no service is running on the port.
	* </pre>
	*/
	public Long get_icmptotportunreachabletx() throws Exception {
		return this.icmptotportunreachabletx;
	}

	/**
	* <pre>
	* ICMP Need Fragmentation error messages received for TCP packets. The state of the connection for these packets is not maintained on the NetScaler.
	* </pre>
	*/
	public Long get_icmptotnotcpconn() throws Exception {
		return this.icmptotnotcpconn;
	}

	/**
	* <pre>
	* ICMP Fragmentation Needed error messages received for packets that contain an invalid TCP address.
	* </pre>
	*/
	public Long get_icmptotinvalidtcpseqno() throws Exception {
		return this.icmptotinvalidtcpseqno;
	}

	/**
	* <pre>
	* Limit for ICMP packets handled every 10 milliseconds. Default value, 0, applies no limit.
This is a configurable value using the set rateControl command.
 
	* </pre>
	*/
	public Long get_icmpcurratethreshold() throws Exception {
		return this.icmpcurratethreshold;
	}

	/**
	* <pre>
	* Rate (/s) counter for icmptottxbytes
	* </pre>
	*/
	public Long get_icmptxbytesrate() throws Exception {
		return this.icmptxbytesrate;
	}

	/**
	* <pre>
	* converts nitro response into object and returns the object array in case of get request.
	* </pre>
	*/
	protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception {
		protocolicmp_stats[] resources = new protocolicmp_stats[1];
		protocolicmp_response result = (protocolicmp_response) service.get_payload_formatter().string_to_resource(protocolicmp_response.class, response);
		if(result.errorcode != 0) {
			if (result.errorcode == 444) {
				service.clear_session();
			}
			if(result.severity != null)
			{
				if (result.severity.equals("ERROR"))
					throw new nitro_exception(result.message,result.errorcode);
			}
			else
			{
				throw new nitro_exception(result.message,result.errorcode);
			}
		}
		resources[0] = result.protocolicmp;
		return resources;
	}

	/**
	* <pre>
	* Returns the value of object identifier argument
	* </pre>
	*/

	protected String get_object_name() {
		return null;
	}

	/**
	* Use this API to fetch the statistics of all protocolicmp_stats resources that are configured on netscaler.
	*/
	public static protocolicmp_stats get(nitro_service service) throws Exception{
		protocolicmp_stats obj = new protocolicmp_stats();
		protocolicmp_stats[] response = (protocolicmp_stats[])obj.stat_resources(service);
		return response[0];
	}

	/**
	* Use this API to fetch the statistics of all protocolicmp_stats resources that are configured on netscaler.
	*/
	public static protocolicmp_stats get(nitro_service service,  options option) throws Exception{
		protocolicmp_stats obj = new protocolicmp_stats();
		protocolicmp_stats[] response = (protocolicmp_stats[])obj.stat_resources(service,option);
		return response[0];
	}

	public static class clearstatsEnum {
		public static final String basic = "basic";
		public static final String full = "full";
	}
}
