/*
* Copyright (c) 2008-2015 Citrix Systems, Inc.
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*/

package com.citrix.netscaler.nitro.resource.stat.snmp;

import com.citrix.netscaler.nitro.resource.base.*;
import com.citrix.netscaler.nitro.service.nitro_service;
import com.citrix.netscaler.nitro.service.options;
import com.citrix.netscaler.nitro.util.*;
import com.citrix.netscaler.nitro.exception.nitro_exception;

class snmp_response extends base_response
{
	public snmp_stats snmp;
}

public class snmp_stats extends base_resource
{
	private String clearstats;
	private Long snmptotrxpkts;
	private Long snmprxpktsrate;
	private Long snmptottxpkts;
	private Long snmptxpktsrate;
	private Long snmptotgetreqs;
	private Long snmpgetreqsrate;
	private Long snmptotgetnextreqs;
	private Long snmpgetnextreqsrate;
	private Long snmptotgetbulkreqs;
	private Long snmpgetbulkreqsrate;
	private Long snmptotresponses;
	private Long snmpresponsesrate;
	private Long snmptottraps;
	private Long snmptoterrreqdropped;
	private Long snmptotparseerrs;
	private Long snmptotbadversions;
	private Long snmptotbadcommname;
	private Long snmptotbadcommuse;
	private Long snmpunsupportedsecuritylevel;
	private Long snmpnotintimewindow;
	private Long snmpunknownusername;
	private Long snmpunknownengineids;
	private Long snmpwrongdigests;
	private Long snmpdecryptionerrors;

	/**
	* <pre>
	* Clear the statsistics / counters
	* </pre>
	*/
	public void set_clearstats(String clearstats) throws Exception{
		this.clearstats = clearstats;
	}

	/**
	* <pre>
	* Clear the statsistics / counters.<br> Possible values = basic, full
	* </pre>
	*/
	public String get_clearstats() throws Exception {
		return this.clearstats;
	}

	/**
	* <pre>
	* SNMP packets that were dropped because they could not be decrypted.
	* </pre>
	*/
	public Long get_snmpdecryptionerrors() throws Exception {
		return this.snmpdecryptionerrors;
	}

	/**
	* <pre>
	* SNMP Get-Response PDUs that have been generated by the NetScaler.
	* </pre>
	*/
	public Long get_snmptotresponses() throws Exception {
		return this.snmptotresponses;
	}

	/**
	* <pre>
	* The total number of SNMP Messages received that represented an SNMP operation which was not allowed by the SNMP community named in the Message.
	* </pre>
	*/
	public Long get_snmptotbadcommuse() throws Exception {
		return this.snmptotbadcommuse;
	}

	/**
	* <pre>
	* SNMP requests dropped.
	* </pre>
	*/
	public Long get_snmptoterrreqdropped() throws Exception {
		return this.snmptoterrreqdropped;
	}

	/**
	* <pre>
	* Rate (/s) counter for snmptotgetnextreqs
	* </pre>
	*/
	public Long get_snmpgetnextreqsrate() throws Exception {
		return this.snmpgetnextreqsrate;
	}

	/**
	* <pre>
	* Number of SNMP messages received, which were for an unsupported SNMP version.
	* </pre>
	*/
	public Long get_snmptotbadversions() throws Exception {
		return this.snmptotbadversions;
	}

	/**
	* <pre>
	* SNMP packets received.
	* </pre>
	*/
	public Long get_snmptotrxpkts() throws Exception {
		return this.snmptotrxpkts;
	}

	/**
	* <pre>
	* Rate (/s) counter for snmptottxpkts
	* </pre>
	*/
	public Long get_snmptxpktsrate() throws Exception {
		return this.snmptxpktsrate;
	}

	/**
	* <pre>
	* Rate (/s) counter for snmptotresponses
	* </pre>
	*/
	public Long get_snmpresponsesrate() throws Exception {
		return this.snmpresponsesrate;
	}

	/**
	* <pre>
	* Rate (/s) counter for snmptotgetreqs
	* </pre>
	*/
	public Long get_snmpgetreqsrate() throws Exception {
		return this.snmpgetreqsrate;
	}

	/**
	* <pre>
	* SNMP messages received, which used an SNMP community name not known to the NetScaler.
	* </pre>
	*/
	public Long get_snmptotbadcommname() throws Exception {
		return this.snmptotbadcommname;
	}

	/**
	* <pre>
	* SNMP Get-Next PDUs that have been accepted and processed.
	* </pre>
	*/
	public Long get_snmptotgetnextreqs() throws Exception {
		return this.snmptotgetnextreqs;
	}

	/**
	* <pre>
	* SNMP packets transmitted.
	* </pre>
	*/
	public Long get_snmptottxpkts() throws Exception {
		return this.snmptottxpkts;
	}

	/**
	* <pre>
	* SNMP packets that were dropped because they referenced an SNMP engine ID that was not known to the NetScaler.
	* </pre>
	*/
	public Long get_snmpunknownengineids() throws Exception {
		return this.snmpunknownengineids;
	}

	/**
	* <pre>
	* SNMP packets that were dropped because they did not contain the expected digest value.
	* </pre>
	*/
	public Long get_snmpwrongdigests() throws Exception {
		return this.snmpwrongdigests;
	}

	/**
	* <pre>
	* Rate (/s) counter for snmptotgetbulkreqs
	* </pre>
	*/
	public Long get_snmpgetbulkreqsrate() throws Exception {
		return this.snmpgetbulkreqsrate;
	}

	/**
	* <pre>
	* SNMP packets that were dropped because they appeared outside of the authoritative SNMP engine's window.
	* </pre>
	*/
	public Long get_snmpnotintimewindow() throws Exception {
		return this.snmpnotintimewindow;
	}

	/**
	* <pre>
	* SNMP Get-Bulk PDUs that have been accepted and processed.
	* </pre>
	*/
	public Long get_snmptotgetbulkreqs() throws Exception {
		return this.snmptotgetbulkreqs;
	}

	/**
	* <pre>
	* Number of ASN.1 or BER errors encountered when decoding received SNMP Messages.
	* </pre>
	*/
	public Long get_snmptotparseerrs() throws Exception {
		return this.snmptotparseerrs;
	}

	/**
	* <pre>
	* SNMP packets that were dropped because they referenced a user that was  not  known to the SNMP engine.
	* </pre>
	*/
	public Long get_snmpunknownusername() throws Exception {
		return this.snmpunknownusername;
	}

	/**
	* <pre>
	* SNMP packets that were dropped because they requested a security level that was
unknown to the NetScaler or otherwise unavailable.

	* </pre>
	*/
	public Long get_snmpunsupportedsecuritylevel() throws Exception {
		return this.snmpunsupportedsecuritylevel;
	}

	/**
	* <pre>
	* SNMP Get-Request PDUs that have been accepted and processed.
	* </pre>
	*/
	public Long get_snmptotgetreqs() throws Exception {
		return this.snmptotgetreqs;
	}

	/**
	* <pre>
	* Rate (/s) counter for snmptotrxpkts
	* </pre>
	*/
	public Long get_snmprxpktsrate() throws Exception {
		return this.snmprxpktsrate;
	}

	/**
	* <pre>
	* SNMP Trap PDUs that have been generated by the NetScaler.
	* </pre>
	*/
	public Long get_snmptottraps() throws Exception {
		return this.snmptottraps;
	}

	/**
	* <pre>
	* converts nitro response into object and returns the object array in case of get request.
	* </pre>
	*/
	protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception {
		snmp_stats[] resources = new snmp_stats[1];
		snmp_response result = (snmp_response) service.get_payload_formatter().string_to_resource(snmp_response.class, response);
		if(result.errorcode != 0) {
			if (result.errorcode == 444) {
				service.clear_session();
			}
			if(result.severity != null)
			{
				if (result.severity.equals("ERROR"))
					throw new nitro_exception(result.message,result.errorcode);
			}
			else
			{
				throw new nitro_exception(result.message,result.errorcode);
			}
		}
		resources[0] = result.snmp;
		return resources;
	}

	/**
	* <pre>
	* Returns the value of object identifier argument
	* </pre>
	*/

	protected String get_object_name() {
		return null;
	}

	/**
	* Use this API to fetch the statistics of all snmp_stats resources that are configured on netscaler.
	*/
	public static snmp_stats get(nitro_service service) throws Exception{
		snmp_stats obj = new snmp_stats();
		snmp_stats[] response = (snmp_stats[])obj.stat_resources(service);
		return response[0];
	}

	/**
	* Use this API to fetch the statistics of all snmp_stats resources that are configured on netscaler.
	*/
	public static snmp_stats get(nitro_service service,  options option) throws Exception{
		snmp_stats obj = new snmp_stats();
		snmp_stats[] response = (snmp_stats[])obj.stat_resources(service,option);
		return response[0];
	}

	public static class clearstatsEnum {
		public static final String basic = "basic";
		public static final String full = "full";
	}
}
