/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.datatypes;

import java.net.Inet6Address;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class MPSConstraint {
    public abstract void validate(Object var1, String var2) throws Exception;

    public static boolean isValidIP4(String addr) {
        StringTokenizer st = new StringTokenizer(addr, ".");
        if (st.countTokens() != 4) {
            return false;
        }
        while (st.hasMoreElements()) {
            try {
                int val = Integer.parseInt(st.nextToken());
                if (val <= 255 && val >= 0) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIP6(String addr) {
        try {
            Inet6Address inetObj = (Inet6Address)Inet6Address.getByName(addr);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidIP(String addr) {
        if (MPSConstraint.isValidIP4(addr)) {
            return true;
        }
        return MPSConstraint.isValidIP6(addr);
    }

    public static boolean isValidHostName(String addr) {
        Pattern pattern;
        if (addr.length() > 255) {
            return false;
        }
        String regEx = "^[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9_-]*[A-Za-z0-9]$";
        try {
            pattern = Pattern.compile(regEx);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        String[] tokens = addr.split(".");
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].length() > 63) {
                return false;
            }
            Matcher matcher = pattern.matcher(tokens[i]);
            if (matcher != null) {
                if (matcher.matches()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isValidInternetHost(String addr) {
        if (MPSConstraint.isValidIP(addr)) {
            return true;
        }
        return MPSConstraint.isValidHostName(addr);
    }
}

