/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.datatypes;

import com.citrix.sdx.nitro.datatypes.MPSConstraint;

public class MPSConstraintInt
extends MPSConstraint {
    private boolean isRequired = false;
    private int maxValue;
    private int minValue = Integer.MIN_VALUE;
    private int defaultValue;

    public MPSConstraintInt() {
        this.maxValue = Integer.MAX_VALUE;
        this.defaultValue = new Integer(-1);
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void validate(Object _value, String label) throws Exception {
        if (_value == null) {
            _value = this.defaultValue;
        }
        int value = (Integer)_value;
        if (!this.isRequired && value == this.defaultValue) {
            return;
        }
        if (value < this.minValue) {
            throw new Exception(label + " value: " + value + " is less than minimum value: " + this.minValue);
        }
        if (value > this.maxValue) {
            throw new Exception(label + " value: " + value + " is greater than maximun value: " + this.maxValue);
        }
    }
}

