/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.datatypes;

import com.citrix.sdx.nitro.datatypes.MPSConstraint;

public class MPSConstraintLong
extends MPSConstraint {
    private boolean isRequired = false;
    private long maxValue;
    private long minValue = Long.MIN_VALUE;
    private long defaultValue;

    public MPSConstraintLong() {
        this.maxValue = Long.MAX_VALUE;
        this.defaultValue = new Long(-1L);
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void validate(Object _value, String label) throws Exception {
        if (_value == null) {
            _value = this.defaultValue;
        }
        long value = (Long)_value;
        if (!this.isRequired && value == this.defaultValue) {
            return;
        }
        if (value < this.minValue) {
            throw new Exception(label + " value: " + value + " is less than minimum value: " + this.minValue);
        }
        if (value > this.maxValue) {
            throw new Exception(label + " value: " + value + " is greater than maximun value: " + this.maxValue);
        }
    }
}

