/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.datatypes;

import com.citrix.sdx.nitro.datatypes.MPSConstraint;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MPSConstraintString
extends MPSConstraint {
    private boolean isRequired = false;
    private int maxStrLen = Integer.MAX_VALUE;
    public int minStrLen = 0;
    private String charSetRegEx = "";

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void setMaxStrLen(int maxStrLen) {
        this.maxStrLen = maxStrLen;
    }

    public void setMinStrLen(int minStrLen) {
        this.minStrLen = minStrLen;
    }

    public void setCharSetRegEx(String charSetRegEx) {
        this.charSetRegEx = charSetRegEx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Object _value, String label) throws Exception {
        Matcher matcher;
        if (_value == null) {
            _value = "";
        }
        String value = (String)_value;
        if (!this.isRequired && value.length() == 0) {
            return;
        }
        if (value.length() < this.minStrLen) {
            throw new Exception(label + " String length: " + value.length() + " is less than minimum length: " + this.minStrLen);
        }
        if (value.length() > this.maxStrLen) {
            throw new Exception(label + " String length: " + value.length() + " is greater than maximum length: " + this.maxStrLen);
        }
        if (this.charSetRegEx.length() == 0) {
            return;
        }
        try {
            Pattern pattern = Pattern.compile(this.charSetRegEx);
            matcher = pattern.matcher(value);
        }
        catch (PatternSyntaxException e) {
            throw new Exception("charSetRegEx:" + this.charSetRegEx + " pattern compilation failed " + e.getMessage());
        }
        if (matcher == null) throw new Exception(label + " String: " + value + " Null matcher value returned");
        if (!matcher.matches()) throw new Exception(label + " String: " + value + " does not comply with characters: " + this.charSetRegEx);
        if (matcher.start() != 0 || matcher.end() != value.length()) return;
    }
}

