/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.datatypes;

import com.citrix.sdx.nitro.datatypes.MPSConstraintDouble;
import com.citrix.sdx.nitro.datatypes.MPSDatatype;

public class MPSDouble
extends MPSDatatype {
    private Double value;
    private MPSConstraintDouble[] constraints = new MPSConstraintDouble[4];

    public MPSDouble() {
        this(null);
    }

    public MPSDouble(Double _value) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i] = new MPSConstraintDouble();
        }
        this.value = _value;
    }

    public void setConstraintDefaultValue(double defaultValue) {
        for (int _type = 0; _type < 4; ++_type) {
            this.constraints[_type].setDefaultValue(defaultValue);
        }
    }

    public void setConstraintIsReq(int constraintType, boolean isRequired) {
        if (constraintType == 4) {
            for (int _type = 0; _type < 4; ++_type) {
                this.constraints[_type].setIsRequired(isRequired);
            }
        } else {
            this.constraints[constraintType].setIsRequired(isRequired);
        }
    }

    public void setConstraintMaxValue(int constraintType, double maxValue) {
        if (constraintType == 4) {
            for (int _type = 0; _type < 4; ++_type) {
                this.constraints[_type].setMaxValue(maxValue);
            }
        } else {
            this.constraints[constraintType].setMaxValue(maxValue);
        }
    }

    public void setConstraintMinValue(int constraintType, double minValue) {
        if (constraintType == 4) {
            for (int _type = 0; _type < 4; ++_type) {
                this.constraints[_type].setMinValue(minValue);
            }
        } else {
            this.constraints[constraintType].setMinValue(minValue);
        }
    }

    public void validate(String operationType, Object _value, String label) throws Exception {
        this.value = (Double)_value;
        int constraintType = this.getConstraintType(operationType);
        if (constraintType == 5) {
            throw new Exception(label + " Invalid operation type");
        }
        this.constraints[constraintType].validate(this.value, label);
    }
}

