/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.datatypes;

import com.citrix.sdx.nitro.datatypes.MPSConstraintDoubleLong;
import com.citrix.sdx.nitro.datatypes.MPSDatatype;

public class MPSDoubleLong
extends MPSDatatype {
    private Double value;
    private MPSConstraintDoubleLong[] constraints = new MPSConstraintDoubleLong[4];

    public MPSDoubleLong() {
        this(null);
    }

    public MPSDoubleLong(Double _value) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i] = new MPSConstraintDoubleLong();
        }
        this.value = _value;
    }

    public void setConstraintDefaultValue(double defaultValue) {
        for (int _type = 0; _type < 4; ++_type) {
            this.constraints[_type].setDefaultValue(defaultValue);
        }
    }

    public void setConstraintIsReq(int constraintType, boolean isRequired) {
        if (constraintType == 4) {
            for (int _type = 0; _type < 4; ++_type) {
                this.constraints[_type].setIsRequired(isRequired);
            }
        } else {
            this.constraints[constraintType].setIsRequired(isRequired);
        }
    }

    public void setConstraintMaxValue(int constraintType, double maxValue) {
        if (constraintType == 4) {
            for (int _type = 0; _type < 4; ++_type) {
                this.constraints[_type].setMaxValue(maxValue);
            }
        } else {
            this.constraints[constraintType].setMaxValue(maxValue);
        }
    }

    public void setConstraintMinValue(int constraintType, double minValue) {
        if (constraintType == 4) {
            for (int _type = 0; _type < 4; ++_type) {
                this.constraints[_type].setMinValue(minValue);
            }
        } else {
            this.constraints[constraintType].setMinValue(minValue);
        }
    }

    public void validate(String operationType, Object _value, String label) throws Exception {
        this.value = (Double)_value;
        int constraintType = this.getConstraintType(operationType);
        if (constraintType == 5) {
            throw new Exception(label + " Invalid operation type");
        }
        this.constraints[constraintType].validate(this.value, label);
    }
}

