/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.resource.base;

import com.citrix.sdx.nitro.datatypes.MPSInt;
import com.citrix.sdx.nitro.datatypes.MPSString;
import com.citrix.sdx.nitro.exception.nitro_exception;
import com.citrix.sdx.nitro.resource.base.base_resource;
import com.citrix.sdx.nitro.resource.base.login_response;
import com.citrix.sdx.nitro.resource.base.login_responses;
import com.citrix.sdx.nitro.service.nitro_service;

public class login
extends base_resource {
    private String password;
    private Integer session_timeout;
    private String sessionid;
    private String username;
    private Long __count;

    protected String get_object_type() {
        return "login";
    }

    protected String get_object_id() {
        return null;
    }

    public void set_password(String password) {
        this.password = password;
    }

    public String get_password() {
        return this.password;
    }

    public void set_session_timeout(Integer session_timeout) {
        this.session_timeout = session_timeout;
    }

    public Integer get_session_timeout() {
        return this.session_timeout;
    }

    public void set_sessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String get_sessionid() {
        return this.sessionid;
    }

    public void set_username(String username) {
        this.username = username;
    }

    public String get_username() {
        return this.username;
    }

    public static login add(nitro_service client, login resource) throws Exception {
        resource.validate("add");
        return ((login[])resource.perform_operation(client, "add"))[0];
    }

    public static login[] add(nitro_service client, login[] resources) throws Exception {
        if (resources == null) {
            throw new Exception("Null resource array");
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i].validate("add");
        }
        if (resources.length == 1) {
            return (login[])resources[0].perform_operation(client, "add");
        }
        return (login[])login.perform_operation_bulk_request(client, resources, "add");
    }

    public static login delete(nitro_service client, login resource) throws Exception {
        resource.validate("delete");
        return ((login[])resource.delete_resource(client))[0];
    }

    public static login[] delete(nitro_service client, login[] resources) throws Exception {
        if (resources == null) {
            throw new Exception("Null resource array");
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i].validate("delete");
        }
        if (resources.length == 1) {
            return (login[])resources[0].delete_resource(client);
        }
        return (login[])login.delete_bulk_request(client, resources);
    }

    protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception {
        login_response result = (login_response)service.get_payload_formatter().string_to_resource(login_response.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result.login;
    }

    protected base_resource[] get_nitro_bulk_response(nitro_service service, String response) throws Exception {
        login_responses result = (login_responses)service.get_payload_formatter().string_to_resource(login_responses.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            throw new nitro_exception(result.message, result.errorcode, result.login_response_array);
        }
        base_resource[] result_login = new login[result.login_response_array.length];
        for (int i = 0; i < result.login_response_array.length; ++i) {
            result_login[i] = result.login_response_array[i].login[0];
        }
        return result_login;
    }

    protected void validate(String operationType) throws Exception {
        super.validate(operationType);
        MPSString sessionid_validator = new MPSString();
        sessionid_validator.setConstraintIsReq(2, true);
        sessionid_validator.validate(operationType, this.sessionid, "\"sessionid\"");
        MPSString username_validator = new MPSString();
        username_validator.setConstraintCharSetRegEx(4, "[ a-zA-Z0-9_#.:@=-]+");
        username_validator.setConstraintMaxStrLen(4, 128);
        username_validator.setConstraintMinStrLen(4, 1);
        username_validator.setConstraintIsReq(0, true);
        username_validator.validate(operationType, this.username, "\"username\"");
        MPSString password_validator = new MPSString();
        password_validator.setConstraintMaxStrLen(4, 128);
        password_validator.setConstraintMinStrLen(4, 1);
        password_validator.setConstraintIsReq(0, true);
        password_validator.validate(operationType, this.password, "\"password\"");
        MPSInt session_timeout_validator = new MPSInt();
        session_timeout_validator.validate(operationType, this.session_timeout, "\"session_timeout\"");
    }
}

