/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.resource.config.mps;

import com.citrix.sdx.nitro.datatypes.MPSIPAddress;
import com.citrix.sdx.nitro.datatypes.MPSInt;
import com.citrix.sdx.nitro.datatypes.MPSString;
import com.citrix.sdx.nitro.exception.nitro_exception;
import com.citrix.sdx.nitro.resource.base.base_resource;
import com.citrix.sdx.nitro.resource.config.mps.audit_log_response;
import com.citrix.sdx.nitro.resource.config.mps.audit_log_responses;
import com.citrix.sdx.nitro.service.nitro_service;
import com.citrix.sdx.nitro.service.options;
import com.citrix.sdx.nitro.util.filtervalue;

public class audit_log
extends base_resource {
    private String status;
    private Integer port;
    private String message;
    private String username;
    private Integer audittime;
    private String id;
    private String ip_address;
    private String resource_name;
    private String operation;
    private String resource_type;
    private Long __count;

    protected String get_object_type() {
        return "audit_log";
    }

    protected String get_object_id() {
        return this.id;
    }

    public String get_status() {
        return this.status;
    }

    public Integer get_port() {
        return this.port;
    }

    public String get_message() {
        return this.message;
    }

    public String get_username() {
        return this.username;
    }

    public Integer get_audittime() {
        return this.audittime;
    }

    public void set_id(String id) {
        this.id = id;
    }

    public String get_id() {
        return this.id;
    }

    public String get_ip_address() {
        return this.ip_address;
    }

    public String get_resource_name() {
        return this.resource_name;
    }

    public String get_operation() {
        return this.operation;
    }

    public String get_resource_type() {
        return this.resource_type;
    }

    public static audit_log[] get(nitro_service client) throws Exception {
        audit_log resource = new audit_log();
        resource.validate("get");
        return (audit_log[])resource.get_resources(client);
    }

    public static audit_log get(nitro_service client, audit_log resource) throws Exception {
        resource.validate("get");
        return ((audit_log[])resource.get_resources(client))[0];
    }

    public static audit_log[] get_filtered(nitro_service service, String filter) throws Exception {
        audit_log obj = new audit_log();
        options option = new options();
        option.set_filter(filter);
        audit_log[] response = (audit_log[])obj.getfiltered(service, option);
        return response;
    }

    public static audit_log[] get_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        audit_log obj = new audit_log();
        options option = new options();
        option.set_filter(filter);
        audit_log[] response = (audit_log[])obj.getfiltered(service, option);
        return response;
    }

    public static long count(nitro_service service) throws Exception {
        audit_log obj = new audit_log();
        options option = new options();
        option.set_count(true);
        audit_log[] response = (audit_log[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, String filter) throws Exception {
        audit_log obj = new audit_log();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        audit_log[] response = (audit_log[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        audit_log obj = new audit_log();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        audit_log[] response = (audit_log[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception {
        audit_log_response result = (audit_log_response)service.get_payload_formatter().string_to_resource(audit_log_response.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result.audit_log;
    }

    protected base_resource[] get_nitro_bulk_response(nitro_service service, String response) throws Exception {
        audit_log_responses result = (audit_log_responses)service.get_payload_formatter().string_to_resource(audit_log_responses.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            throw new nitro_exception(result.message, result.errorcode, result.audit_log_response_array);
        }
        base_resource[] result_audit_log = new audit_log[result.audit_log_response_array.length];
        for (int i = 0; i < result.audit_log_response_array.length; ++i) {
            result_audit_log[i] = result.audit_log_response_array[i].audit_log[0];
        }
        return result_audit_log;
    }

    protected void validate(String operationType) throws Exception {
        super.validate(operationType);
        MPSString id_validator = new MPSString();
        id_validator.setConstraintIsReq(2, true);
        id_validator.setConstraintIsReq(1, true);
        id_validator.validate(operationType, this.id, "\"id\"");
        MPSString username_validator = new MPSString();
        username_validator.setConstraintMaxStrLen(4, 128);
        username_validator.setConstraintMinStrLen(4, 1);
        username_validator.validate(operationType, this.username, "\"username\"");
        MPSIPAddress ip_address_validator = new MPSIPAddress();
        ip_address_validator.validate(operationType, this.ip_address, "\"ip_address\"");
        MPSInt port_validator = new MPSInt();
        port_validator.validate(operationType, this.port, "\"port\"");
        MPSString resource_type_validator = new MPSString();
        resource_type_validator.setConstraintMaxStrLen(4, 64);
        resource_type_validator.setConstraintMinStrLen(4, 1);
        resource_type_validator.validate(operationType, this.resource_type, "\"resource_type\"");
        MPSString resource_name_validator = new MPSString();
        resource_name_validator.setConstraintMaxStrLen(4, 128);
        resource_name_validator.setConstraintMinStrLen(4, 1);
        resource_name_validator.validate(operationType, this.resource_name, "\"resource_name\"");
        MPSInt audittime_validator = new MPSInt();
        audittime_validator.validate(operationType, this.audittime, "\"audittime\"");
        MPSString operation_validator = new MPSString();
        operation_validator.setConstraintMaxStrLen(4, 32);
        operation_validator.setConstraintMinStrLen(4, 1);
        operation_validator.validate(operationType, this.operation, "\"operation\"");
        MPSString status_validator = new MPSString();
        status_validator.setConstraintMaxStrLen(4, 128);
        status_validator.validate(operationType, this.status, "\"status\"");
        MPSString message_validator = new MPSString();
        message_validator.setConstraintMaxStrLen(4, 256);
        message_validator.setConstraintMinStrLen(4, 1);
        message_validator.validate(operationType, this.message, "\"message\"");
    }
}

