/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.resource.config.mps;

import com.citrix.sdx.nitro.datatypes.MPSBoolean;
import com.citrix.sdx.nitro.datatypes.MPSDouble;
import com.citrix.sdx.nitro.datatypes.MPSDoubleLong;
import com.citrix.sdx.nitro.datatypes.MPSInt;
import com.citrix.sdx.nitro.datatypes.MPSString;
import com.citrix.sdx.nitro.exception.nitro_exception;
import com.citrix.sdx.nitro.resource.base.base_resource;
import com.citrix.sdx.nitro.resource.config.mps.host_device_response;
import com.citrix.sdx.nitro.resource.config.mps.host_device_responses;
import com.citrix.sdx.nitro.resource.config.mps.managed_device;
import com.citrix.sdx.nitro.service.nitro_service;
import com.citrix.sdx.nitro.service.options;
import com.citrix.sdx.nitro.util.filtervalue;

public class host_device
extends managed_device {
    private Double tx;
    private Double memory_total;
    private Integer ssl_cores_total;
    private Double rx;
    private Double memory_usage;
    private String uuid;
    private Integer number_of_cpu;
    private Double memory_free;
    private String uptime;
    private Double cpu_usage;
    private Boolean enabled;
    private Integer ssl_cores_free;
    private Long __count;

    protected String get_object_type() {
        return "host_device";
    }

    protected String get_object_id() {
        return super.get_object_id();
    }

    public Double get_tx() {
        return this.tx;
    }

    public Double get_memory_total() {
        return this.memory_total;
    }

    public Integer get_ssl_cores_total() {
        return this.ssl_cores_total;
    }

    public Double get_rx() {
        return this.rx;
    }

    public Double get_memory_usage() {
        return this.memory_usage;
    }

    public String get_uuid() {
        return this.uuid;
    }

    public Integer get_number_of_cpu() {
        return this.number_of_cpu;
    }

    public Double get_memory_free() {
        return this.memory_free;
    }

    public String get_uptime() {
        return this.uptime;
    }

    public Double get_cpu_usage() {
        return this.cpu_usage;
    }

    public Boolean get_enabled() {
        return this.enabled;
    }

    public Integer get_ssl_cores_free() {
        return this.ssl_cores_free;
    }

    public static host_device[] get(nitro_service client) throws Exception {
        host_device resource = new host_device();
        resource.validate("get");
        return (host_device[])resource.get_resources(client);
    }

    public static host_device get(nitro_service client, host_device resource) throws Exception {
        resource.validate("get");
        return ((host_device[])resource.get_resources(client))[0];
    }

    public static host_device[] get_filtered(nitro_service service, String filter) throws Exception {
        host_device obj = new host_device();
        options option = new options();
        option.set_filter(filter);
        host_device[] response = (host_device[])obj.getfiltered(service, option);
        return response;
    }

    public static host_device[] get_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        host_device obj = new host_device();
        options option = new options();
        option.set_filter(filter);
        host_device[] response = (host_device[])obj.getfiltered(service, option);
        return response;
    }

    public static long count(nitro_service service) throws Exception {
        host_device obj = new host_device();
        options option = new options();
        option.set_count(true);
        host_device[] response = (host_device[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, String filter) throws Exception {
        host_device obj = new host_device();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        host_device[] response = (host_device[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        host_device obj = new host_device();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        host_device[] response = (host_device[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception {
        host_device_response result = (host_device_response)service.get_payload_formatter().string_to_resource(host_device_response.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result.host_device;
    }

    protected base_resource[] get_nitro_bulk_response(nitro_service service, String response) throws Exception {
        host_device_responses result = (host_device_responses)service.get_payload_formatter().string_to_resource(host_device_responses.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            throw new nitro_exception(result.message, result.errorcode, result.host_device_response_array);
        }
        base_resource[] result_host_device = new host_device[result.host_device_response_array.length];
        for (int i = 0; i < result.host_device_response_array.length; ++i) {
            result_host_device[i] = result.host_device_response_array[i].host_device[0];
        }
        return result_host_device;
    }

    protected void validate(String operationType) throws Exception {
        super.validate(operationType);
        MPSString uuid_validator = new MPSString();
        uuid_validator.setConstraintCharSetRegEx(4, "[ a-zA-Z0-9_#.:@=-]+");
        uuid_validator.setConstraintMaxStrLen(4, 128);
        uuid_validator.setConstraintMinStrLen(4, 1);
        uuid_validator.validate(operationType, this.uuid, "\"uuid\"");
        MPSBoolean enabled_validator = new MPSBoolean();
        enabled_validator.validate(operationType, this.enabled, "\"enabled\"");
        MPSInt number_of_cpu_validator = new MPSInt();
        number_of_cpu_validator.validate(operationType, this.number_of_cpu, "\"number_of_cpu\"");
        MPSDouble cpu_usage_validator = new MPSDouble();
        cpu_usage_validator.validate(operationType, this.cpu_usage, "\"cpu_usage\"");
        MPSDoubleLong memory_total_validator = new MPSDoubleLong();
        memory_total_validator.validate(operationType, this.memory_total, "\"memory_total\"");
        MPSDoubleLong memory_free_validator = new MPSDoubleLong();
        memory_free_validator.validate(operationType, this.memory_free, "\"memory_free\"");
        MPSDouble memory_usage_validator = new MPSDouble();
        memory_usage_validator.validate(operationType, this.memory_usage, "\"memory_usage\"");
        MPSDouble tx_validator = new MPSDouble();
        tx_validator.validate(operationType, this.tx, "\"tx\"");
        MPSDouble rx_validator = new MPSDouble();
        rx_validator.validate(operationType, this.rx, "\"rx\"");
        MPSString uptime_validator = new MPSString();
        uptime_validator.setConstraintMaxStrLen(4, 128);
        uptime_validator.setConstraintMinStrLen(4, 1);
        uptime_validator.validate(operationType, this.uptime, "\"uptime\"");
        MPSInt ssl_cores_total_validator = new MPSInt();
        ssl_cores_total_validator.validate(operationType, this.ssl_cores_total, "\"ssl_cores_total\"");
        MPSInt ssl_cores_free_validator = new MPSInt();
        ssl_cores_free_validator.validate(operationType, this.ssl_cores_free, "\"ssl_cores_free\"");
    }
}

