/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.resource.config.mps;

import com.citrix.sdx.nitro.datatypes.MPSBoolean;
import com.citrix.sdx.nitro.datatypes.MPSInt;
import com.citrix.sdx.nitro.exception.nitro_exception;
import com.citrix.sdx.nitro.resource.base.base_resource;
import com.citrix.sdx.nitro.resource.config.mps.ntp_param_response;
import com.citrix.sdx.nitro.resource.config.mps.ntp_param_responses;
import com.citrix.sdx.nitro.service.nitro_service;
import com.citrix.sdx.nitro.service.options;
import com.citrix.sdx.nitro.util.filtervalue;

public class ntp_param
extends base_resource {
    private Integer[] trusted_key_list;
    private Integer automax_logsec;
    private Integer revoke_logsec;
    private Boolean authentication;
    private Long __count;

    protected String get_object_type() {
        return "ntp_param";
    }

    protected String get_object_id() {
        return null;
    }

    public void set_trusted_key_list(Integer[] trusted_key_list) {
        this.trusted_key_list = trusted_key_list;
    }

    public Integer[] get_trusted_key_list() {
        return this.trusted_key_list;
    }

    public void set_automax_logsec(Integer automax_logsec) {
        this.automax_logsec = automax_logsec;
    }

    public Integer get_automax_logsec() {
        return this.automax_logsec;
    }

    public void set_revoke_logsec(Integer revoke_logsec) {
        this.revoke_logsec = revoke_logsec;
    }

    public Integer get_revoke_logsec() {
        return this.revoke_logsec;
    }

    public void set_authentication(Boolean authentication) {
        this.authentication = authentication;
    }

    public Boolean get_authentication() {
        return this.authentication;
    }

    public static ntp_param[] get(nitro_service client) throws Exception {
        ntp_param resource = new ntp_param();
        resource.validate("get");
        return (ntp_param[])resource.get_resources(client);
    }

    public static ntp_param update(nitro_service client, ntp_param resource) throws Exception {
        resource.validate("modify");
        return ((ntp_param[])resource.update_resource(client))[0];
    }

    public static ntp_param[] update(nitro_service client, ntp_param[] resources) throws Exception {
        if (resources == null) {
            throw new Exception("Null resource array");
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i].validate("modify");
        }
        if (resources.length == 1) {
            return (ntp_param[])resources[0].update_resource(client);
        }
        return (ntp_param[])ntp_param.update_bulk_request(client, resources);
    }

    public static ntp_param[] get_filtered(nitro_service service, String filter) throws Exception {
        ntp_param obj = new ntp_param();
        options option = new options();
        option.set_filter(filter);
        ntp_param[] response = (ntp_param[])obj.getfiltered(service, option);
        return response;
    }

    public static ntp_param[] get_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        ntp_param obj = new ntp_param();
        options option = new options();
        option.set_filter(filter);
        ntp_param[] response = (ntp_param[])obj.getfiltered(service, option);
        return response;
    }

    public static long count(nitro_service service) throws Exception {
        ntp_param obj = new ntp_param();
        options option = new options();
        option.set_count(true);
        ntp_param[] response = (ntp_param[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, String filter) throws Exception {
        ntp_param obj = new ntp_param();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        ntp_param[] response = (ntp_param[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        ntp_param obj = new ntp_param();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        ntp_param[] response = (ntp_param[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception {
        ntp_param_response result = (ntp_param_response)service.get_payload_formatter().string_to_resource(ntp_param_response.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result.ntp_param;
    }

    protected base_resource[] get_nitro_bulk_response(nitro_service service, String response) throws Exception {
        ntp_param_responses result = (ntp_param_responses)service.get_payload_formatter().string_to_resource(ntp_param_responses.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            throw new nitro_exception(result.message, result.errorcode, result.ntp_param_response_array);
        }
        base_resource[] result_ntp_param = new ntp_param[result.ntp_param_response_array.length];
        for (int i = 0; i < result.ntp_param_response_array.length; ++i) {
            result_ntp_param[i] = result.ntp_param_response_array[i].ntp_param[0];
        }
        return result_ntp_param;
    }

    protected void validate(String operationType) throws Exception {
        super.validate(operationType);
        MPSBoolean authentication_validator = new MPSBoolean();
        authentication_validator.validate(operationType, this.authentication, "\"authentication\"");
        MPSInt trusted_key_list_validator = new MPSInt();
        trusted_key_list_validator.setConstraintIsReq(4, true);
        trusted_key_list_validator.setConstraintMinValue(4, 1);
        trusted_key_list_validator.setConstraintMaxValue(4, 65534);
        if (this.trusted_key_list != null) {
            for (int i = 0; i < this.trusted_key_list.length; ++i) {
                trusted_key_list_validator.validate(operationType, this.trusted_key_list[i], "trusted_key_list[" + i + "]");
            }
        }
        MPSInt revoke_logsec_validator = new MPSInt();
        revoke_logsec_validator.setConstraintMinValue(4, 0);
        revoke_logsec_validator.validate(operationType, this.revoke_logsec, "\"revoke_logsec\"");
        MPSInt automax_logsec_validator = new MPSInt();
        automax_logsec_validator.setConstraintMinValue(4, 0);
        automax_logsec_validator.validate(operationType, this.automax_logsec, "\"automax_logsec\"");
    }
}

