/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.resource.config.mps;

import com.citrix.sdx.nitro.datatypes.MPSBoolean;
import com.citrix.sdx.nitro.datatypes.MPSInt;
import com.citrix.sdx.nitro.datatypes.MPSInternetHost;
import com.citrix.sdx.nitro.datatypes.MPSString;
import com.citrix.sdx.nitro.exception.nitro_exception;
import com.citrix.sdx.nitro.resource.base.base_resource;
import com.citrix.sdx.nitro.resource.config.mps.smtp_server_response;
import com.citrix.sdx.nitro.resource.config.mps.smtp_server_responses;
import com.citrix.sdx.nitro.service.nitro_service;
import com.citrix.sdx.nitro.service.options;
import com.citrix.sdx.nitro.util.filtervalue;

public class smtp_server
extends base_resource {
    private String password;
    private Boolean is_auth;
    private String id;
    private Boolean is_ssl;
    private Integer port;
    private String username;
    private String server_name;
    private Long __count;

    protected String get_object_type() {
        return "smtp_server";
    }

    protected String get_object_id() {
        return this.id;
    }

    public void set_password(String password) {
        this.password = password;
    }

    public String get_password() {
        return this.password;
    }

    public void set_is_auth(Boolean is_auth) {
        this.is_auth = is_auth;
    }

    public Boolean get_is_auth() {
        return this.is_auth;
    }

    public void set_id(String id) {
        this.id = id;
    }

    public String get_id() {
        return this.id;
    }

    public void set_is_ssl(Boolean is_ssl) {
        this.is_ssl = is_ssl;
    }

    public Boolean get_is_ssl() {
        return this.is_ssl;
    }

    public void set_port(Integer port) {
        this.port = port;
    }

    public Integer get_port() {
        return this.port;
    }

    public void set_username(String username) {
        this.username = username;
    }

    public String get_username() {
        return this.username;
    }

    public void set_server_name(String server_name) {
        this.server_name = server_name;
    }

    public String get_server_name() {
        return this.server_name;
    }

    public static smtp_server add(nitro_service client, smtp_server resource) throws Exception {
        resource.validate("add");
        return ((smtp_server[])resource.perform_operation(client, "add"))[0];
    }

    public static smtp_server[] add(nitro_service client, smtp_server[] resources) throws Exception {
        if (resources == null) {
            throw new Exception("Null resource array");
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i].validate("add");
        }
        if (resources.length == 1) {
            return (smtp_server[])resources[0].perform_operation(client, "add");
        }
        return (smtp_server[])smtp_server.perform_operation_bulk_request(client, resources, "add");
    }

    public static smtp_server delete(nitro_service client, smtp_server resource) throws Exception {
        resource.validate("delete");
        return ((smtp_server[])resource.delete_resource(client))[0];
    }

    public static smtp_server[] delete(nitro_service client, smtp_server[] resources) throws Exception {
        if (resources == null) {
            throw new Exception("Null resource array");
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i].validate("delete");
        }
        if (resources.length == 1) {
            return (smtp_server[])resources[0].delete_resource(client);
        }
        return (smtp_server[])smtp_server.delete_bulk_request(client, resources);
    }

    public static smtp_server[] get(nitro_service client) throws Exception {
        smtp_server resource = new smtp_server();
        resource.validate("get");
        return (smtp_server[])resource.get_resources(client);
    }

    public static smtp_server get(nitro_service client, smtp_server resource) throws Exception {
        resource.validate("get");
        return ((smtp_server[])resource.get_resources(client))[0];
    }

    public static smtp_server update(nitro_service client, smtp_server resource) throws Exception {
        resource.validate("modify");
        return ((smtp_server[])resource.update_resource(client))[0];
    }

    public static smtp_server[] update(nitro_service client, smtp_server[] resources) throws Exception {
        if (resources == null) {
            throw new Exception("Null resource array");
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i].validate("modify");
        }
        if (resources.length == 1) {
            return (smtp_server[])resources[0].update_resource(client);
        }
        return (smtp_server[])smtp_server.update_bulk_request(client, resources);
    }

    public static smtp_server[] get_filtered(nitro_service service, String filter) throws Exception {
        smtp_server obj = new smtp_server();
        options option = new options();
        option.set_filter(filter);
        smtp_server[] response = (smtp_server[])obj.getfiltered(service, option);
        return response;
    }

    public static smtp_server[] get_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        smtp_server obj = new smtp_server();
        options option = new options();
        option.set_filter(filter);
        smtp_server[] response = (smtp_server[])obj.getfiltered(service, option);
        return response;
    }

    public static long count(nitro_service service) throws Exception {
        smtp_server obj = new smtp_server();
        options option = new options();
        option.set_count(true);
        smtp_server[] response = (smtp_server[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, String filter) throws Exception {
        smtp_server obj = new smtp_server();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        smtp_server[] response = (smtp_server[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    public static long count_filtered(nitro_service service, filtervalue[] filter) throws Exception {
        smtp_server obj = new smtp_server();
        options option = new options();
        option.set_count(true);
        option.set_filter(filter);
        smtp_server[] response = (smtp_server[])obj.get_resources(service, option);
        if (response != null && response.length > 0) {
            return response[0].__count;
        }
        return 0L;
    }

    protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception {
        smtp_server_response result = (smtp_server_response)service.get_payload_formatter().string_to_resource(smtp_server_response.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            if (result.severity != null) {
                if (result.severity.equals("ERROR")) {
                    throw new nitro_exception(result.message, result.errorcode);
                }
            } else {
                throw new nitro_exception(result.message, result.errorcode);
            }
        }
        return result.smtp_server;
    }

    protected base_resource[] get_nitro_bulk_response(nitro_service service, String response) throws Exception {
        smtp_server_responses result = (smtp_server_responses)service.get_payload_formatter().string_to_resource(smtp_server_responses.class, response);
        if (result.errorcode != 0) {
            if (result.errorcode == 444) {
                service.clear_session();
            }
            throw new nitro_exception(result.message, result.errorcode, result.smtp_server_response_array);
        }
        base_resource[] result_smtp_server = new smtp_server[result.smtp_server_response_array.length];
        for (int i = 0; i < result.smtp_server_response_array.length; ++i) {
            result_smtp_server[i] = result.smtp_server_response_array[i].smtp_server[0];
        }
        return result_smtp_server;
    }

    protected void validate(String operationType) throws Exception {
        super.validate(operationType);
        MPSString id_validator = new MPSString();
        id_validator.setConstraintIsReq(2, true);
        id_validator.setConstraintIsReq(1, true);
        id_validator.validate(operationType, this.id, "\"id\"");
        MPSInternetHost server_name_validator = new MPSInternetHost();
        server_name_validator.setConstraintIsReq(0, true);
        server_name_validator.validate(operationType, this.server_name, "\"server_name\"");
        MPSInt port_validator = new MPSInt();
        port_validator.setConstraintMinValue(4, 1);
        port_validator.setConstraintMaxValue(4, 65534);
        port_validator.validate(operationType, this.port, "\"port\"");
        MPSString username_validator = new MPSString();
        username_validator.setConstraintCharSetRegEx(4, "[ a-zA-Z0-9_#.:@=-]+");
        username_validator.setConstraintMaxStrLen(4, 128);
        username_validator.validate(operationType, this.username, "\"username\"");
        MPSString password_validator = new MPSString();
        password_validator.setConstraintMaxStrLen(4, 128);
        password_validator.validate(operationType, this.password, "\"password\"");
        MPSBoolean is_auth_validator = new MPSBoolean();
        is_auth_validator.validate(operationType, this.is_auth, "\"is_auth\"");
        MPSBoolean is_ssl_validator = new MPSBoolean();
        is_ssl_validator.validate(operationType, this.is_ssl, "\"is_ssl\"");
    }
}

