/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.sdx.nitro.service;

import com.citrix.sdx.nitro.exception.nitro_exception;
import com.citrix.sdx.nitro.resource.base.Json;
import com.citrix.sdx.nitro.resource.base.ipayload_formatter;
import com.citrix.sdx.nitro.resource.base.login;

public class nitro_service {
    private String user_name;
    private String password;
    private Integer timeout;
    private String ipaddress;
    private String version;
    private String sessionid;
    private String protocol;
    private ipayload_formatter format;
    private OnerrorEnum onerror;

    public nitro_service(String ip) throws nitro_exception {
        this(ip, new Json(), "http");
    }

    public nitro_service(String ip, String protocol) throws nitro_exception {
        this(ip, new Json(), protocol);
    }

    public nitro_service(String ip, ipayload_formatter format) throws nitro_exception {
        this(ip, format, "http");
    }

    public nitro_service(String ip, ipayload_formatter format, String protocol) throws nitro_exception {
        this.set_protocol(protocol);
        this.ipaddress = ip;
        this.version = "v1";
        this.format = format;
        if (this.format == null) {
            this.format = new Json();
        }
    }

    public void set_sessionid(String id) {
        this.sessionid = id;
    }

    public void set_credential(String username, String password) {
        this.user_name = username;
        this.password = password;
    }

    public void set_timeout(int timeout) {
        this.timeout = new Integer(timeout);
    }

    public void set_timeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean isLogin() {
        return this.sessionid != null;
    }

    public String get_ipaddress() {
        return this.ipaddress;
    }

    public String get_version() {
        return this.version;
    }

    public String get_sessionid() {
        return this.sessionid;
    }

    public String get_protocol() {
        return this.protocol;
    }

    public void set_protocol(String protocol) throws nitro_exception {
        if (protocol == null || !protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            throw new nitro_exception("error: protocol value " + protocol + " is not supported");
        }
        this.protocol = protocol;
    }

    public String get_onerror() {
        if (this.onerror != null) {
            return this.onerror.toString();
        }
        return "";
    }

    public void set_onerror(OnerrorEnum val) {
        this.onerror = val;
    }

    public ipayload_formatter get_payload_formatter() {
        return this.format;
    }

    public login login() throws Exception {
        login login_obj = new login();
        login_obj.set_username(this.user_name);
        login_obj.set_password(this.password);
        login_obj.set_session_timeout(this.timeout);
        login result = login.add(this, login_obj);
        this.sessionid = result.get_sessionid();
        return result;
    }

    public void clear_session() {
        this.sessionid = null;
    }

    public login relogin() throws Exception {
        this.sessionid = null;
        return this.login();
    }

    public login login(String username, String password) throws Exception {
        this.set_credential(username, password);
        return this.login();
    }

    public login login(String username, String password, Integer timeout) throws Exception {
        this.set_credential(username, password);
        this.set_timeout(timeout);
        return this.login();
    }

    public login logout() throws Exception {
        if (this.sessionid == null || this.sessionid.length() <= 0) {
            throw new Exception("User not logged-in");
        }
        login logout_obj = new login();
        logout_obj.set_sessionid(this.sessionid);
        login result = login.delete(this, logout_obj);
        this.sessionid = null;
        this.user_name = null;
        this.password = null;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnerrorEnum {
        EXIT,
        CONTINUE;

    }
}

