/*
 * Decompiled with CFR 0.152.
 */
package com.ckeditor;

import com.ckeditor.CKEditorConfig;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagHelper {
    private static final String[] CHARS_FROM = new String[]{"\\", "/", "\n", "\t", "\r", "\b", "\f", "\""};
    private static final String[] CHARS_TO = new String[]{"\\\\", "\\/", "\\\n", "\\\t", "\\\r", "\\\b", "\\\f", "\\\""};

    public static String script(String input) {
        String out = "<script type=\"text/javascript\">";
        out = out + "//<![CDATA[\n";
        out = out + input;
        out = out + "\n//]]>";
        out = out + "</script>\n";
        return out;
    }

    public static String createCKEditorIncJS(String basePath, String args) {
        return "<script type=\"text/javascript\" src=\"" + basePath + "ckeditor.js" + args + "\"></script>\n";
    }

    public static String jsEncode(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return TagHelper.jsEncode((String)o);
        }
        if (o instanceof Number) {
            return TagHelper.jsEncode((Number)o);
        }
        if (o instanceof Boolean) {
            return TagHelper.jsEncode((Boolean)o);
        }
        if (o instanceof Map) {
            return TagHelper.jsEncode((Map)o);
        }
        if (o instanceof List) {
            return TagHelper.jsEncode((List)o);
        }
        if (o instanceof CKEditorConfig) {
            return TagHelper.jsEncode((CKEditorConfig)o);
        }
        return "";
    }

    public static String jsEncode(String s) {
        if (s.indexOf("@@") == 0) {
            return s.substring(2);
        }
        if (s.length() > 9 && s.substring(0, 9).toUpperCase().equals("CKEDITOR.")) {
            return s;
        }
        return TagHelper.clearString(s);
    }

    public static String jsEncode(Number n) {
        return n.toString().replace(",", ".");
    }

    public static String jsEncode(Boolean b) {
        return b.toString();
    }

    public static String jsEncode(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder("{");
        for (String obj : map.keySet()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(TagHelper.jsEncode((Object)obj));
            sb.append(":");
            sb.append(TagHelper.jsEncode(map.get(obj)));
        }
        sb.append("}");
        return sb.toString();
    }

    public static String jsEncode(List<Object> list) {
        StringBuilder sb = new StringBuilder("[");
        for (Object obj : list) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(TagHelper.jsEncode(obj));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String jsEncode(CKEditorConfig config) {
        StringBuilder sb = new StringBuilder("{");
        for (String obj : config.getConfigValues().keySet()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(TagHelper.jsEncode((Object)obj));
            sb.append(":");
            sb.append(TagHelper.jsEncode(config.getConfigValue(obj)));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String clearString(String s) {
        String string = s;
        for (int i = 0; i < CHARS_FROM.length; ++i) {
            string = string.replace(CHARS_FROM[i], CHARS_TO[i]);
        }
        if (Pattern.compile("[\\[{].*[\\]}]").matcher(string).matches()) {
            return string;
        }
        return "\"" + string + "\"";
    }
}

