/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.stream.cardinality.RegisterSet;
import com.clearspring.analytics.util.IBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class HyperLogLog
implements ICardinality {
    private static final double POW_2_32 = Math.pow(2.0, 32.0);
    private static final double NEGATIVE_POW_2_32 = -4.294967296E9;
    private final RegisterSet registerSet;
    private final int log2m;
    private final double alphaMM;

    public HyperLogLog(double rsd) {
        this(HyperLogLog.log2m(rsd));
    }

    private static int log2m(double rsd) {
        return (int)(Math.log(1.106 / rsd * (1.106 / rsd)) / Math.log(2.0));
    }

    public HyperLogLog(int log2m) {
        this(log2m, new RegisterSet((int)Math.pow(2.0, log2m)));
    }

    public HyperLogLog(int log2m, RegisterSet registerSet) {
        this.registerSet = registerSet;
        this.log2m = log2m;
        int m = (int)Math.pow(2.0, this.log2m);
        switch (log2m) {
            case 4: {
                this.alphaMM = 0.673 * (double)m * (double)m;
                break;
            }
            case 5: {
                this.alphaMM = 0.697 * (double)m * (double)m;
                break;
            }
            case 6: {
                this.alphaMM = 0.709 * (double)m * (double)m;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)m) * (double)m * (double)m;
            }
        }
    }

    @Override
    public boolean offer(Object o) {
        int x = MurmurHash.hash(o);
        int j = x >>> 32 - this.log2m;
        int r = Integer.numberOfLeadingZeros(x << this.log2m | (1 << this.log2m - 1) + 1) + 1;
        if (this.registerSet.get(j) < r) {
            this.registerSet.set(j, r);
            return true;
        }
        return false;
    }

    @Override
    public long cardinality() {
        return this.cardinality(true);
    }

    public long cardinality(boolean enableLongRangeCorrection) {
        double registerSum = 0.0;
        int count = this.registerSet.count;
        for (int j = 0; j < this.registerSet.count; ++j) {
            registerSum += Math.pow(2.0, -1 * this.registerSet.get(j));
        }
        double estimate = this.alphaMM * (1.0 / registerSum);
        if (estimate <= 2.5 * (double)count) {
            double zeros = 0.0;
            for (int z = 0; z < count; ++z) {
                if (this.registerSet.get(z) != 0) continue;
                zeros += 1.0;
            }
            return Math.round((double)count * Math.log((double)count / zeros));
        }
        if (estimate <= 0.03333333333333333 * POW_2_32) {
            return Math.round(estimate);
        }
        if (estimate > 0.03333333333333333 * POW_2_32) {
            if (enableLongRangeCorrection) {
                return Math.round(-4.294967296E9 * Math.log(1.0 - estimate / POW_2_32));
            }
            return Math.round(estimate);
        }
        return 0L;
    }

    @Override
    public int sizeof() {
        return this.registerSet.size * 4;
    }

    @Override
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(this.log2m);
        dos.writeInt(this.registerSet.size * 4);
        for (int x : this.registerSet.bits()) {
            dos.writeInt(x);
        }
        return baos.toByteArray();
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws CardinalityMergeException {
        if (estimators == null || estimators.length == 0) {
            return this;
        }
        int size = this.sizeof();
        RegisterSet mergedSet = new RegisterSet((int)Math.pow(2.0, this.log2m), this.registerSet.bits());
        for (ICardinality estimator : estimators) {
            if (!(estimator instanceof HyperLogLog)) {
                throw new HyperLogLogMergeException("Cannot merge estimators of different class");
            }
            if (estimator.sizeof() != size) {
                throw new HyperLogLogMergeException("Cannot merge estimators of different sizes");
            }
            HyperLogLog hll = (HyperLogLog)estimator;
            for (int b = 0; b < mergedSet.count; ++b) {
                mergedSet.set(b, Math.max(mergedSet.get(b), hll.registerSet.get(b)));
            }
        }
        return new HyperLogLog(this.log2m, mergedSet);
    }

    public static int[] getBits(byte[] mBytes) throws IOException {
        int bitSize = mBytes.length / 4;
        int[] bits = new int[bitSize];
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(mBytes));
        for (int i = 0; i < bitSize; ++i) {
            bits[i] = dis.readInt();
        }
        return bits;
    }

    protected static class HyperLogLogMergeException
    extends CardinalityMergeException {
        public HyperLogLogMergeException(String message) {
            super(message);
        }
    }

    public static class Builder
    implements IBuilder<ICardinality>,
    Serializable {
        private double rsd;

        public Builder(double rsd) {
            this.rsd = rsd;
        }

        @Override
        public HyperLogLog build() {
            return new HyperLogLog(this.rsd);
        }

        @Override
        public int sizeof() {
            int log2m = HyperLogLog.log2m(this.rsd);
            int k = (int)Math.pow(2.0, log2m);
            return RegisterSet.getBits(k) * 4;
        }

        public static HyperLogLog build(byte[] bytes) throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream oi = new DataInputStream(bais);
            int log2m = oi.readInt();
            int size = oi.readInt();
            byte[] longArrayBytes = new byte[size];
            oi.readFully(longArrayBytes);
            return new HyperLogLog(log2m, new RegisterSet((int)Math.pow(2.0, log2m), HyperLogLog.getBits(longArrayBytes)));
        }
    }
}

