/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.constraints;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.constraints.DateConstraint;
import com.clevercloud.biscuit.datalog.constraints.IntConstraint;
import com.clevercloud.biscuit.datalog.constraints.StrConstraint;
import com.clevercloud.biscuit.datalog.constraints.SymbolConstraint;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;

public abstract class ConstraintKind
implements Serializable {
    public abstract Schema.Constraint serialize(long var1);

    public static Either<Error.FormatError, ConstraintKind> deserialize_enum(Schema.Constraint c) {
        if (c.getKind() == Schema.Constraint.Kind.INT) {
            return Int.deserialize(c);
        }
        if (c.getKind() == Schema.Constraint.Kind.STRING) {
            return Str.deserialize(c);
        }
        if (c.getKind() == Schema.Constraint.Kind.DATE) {
            return Date.deserialize(c);
        }
        if (c.getKind() == Schema.Constraint.Kind.SYMBOL) {
            return Symbol.deserialize(c);
        }
        Error.FormatError formatError = new Error().new Error.FormatError();
        formatError.getClass();
        return API.Left((Object)formatError.new Error.FormatError.DeserializationError("invalid constraint kind"));
    }

    public static final class Symbol
    extends ConstraintKind
    implements Serializable {
        private final SymbolConstraint constraint;

        public boolean check(long value) {
            return this.constraint.check(value);
        }

        public Symbol(SymbolConstraint constraint) {
            this.constraint = constraint;
        }

        public String toString() {
            return this.constraint.toString();
        }

        @Override
        public Schema.Constraint serialize(long id) {
            return Schema.Constraint.newBuilder().setId((int)id).setKind(Schema.Constraint.Kind.SYMBOL).setSymbol(this.constraint.serialize()).build();
        }

        public static Either<Error.FormatError, ConstraintKind> deserialize(Schema.Constraint c) {
            long id = c.getId();
            if (!c.hasSymbol()) {
                Error.FormatError formatError = new Error().new Error.FormatError();
                formatError.getClass();
                return API.Left((Object)formatError.new Error.FormatError.DeserializationError("invalid Symbol constraint"));
            }
            Either<Error.FormatError, SymbolConstraint> res = SymbolConstraint.deserialize_enum(c.getSymbol());
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            return API.Right((Object)new Symbol((SymbolConstraint)res.get()));
        }
    }

    public static final class Date
    extends ConstraintKind
    implements Serializable {
        private final DateConstraint constraint;

        public boolean check(long value) {
            return this.constraint.check(value);
        }

        public Date(DateConstraint constraint) {
            this.constraint = constraint;
        }

        public String toString() {
            return this.constraint.toString();
        }

        @Override
        public Schema.Constraint serialize(long id) {
            return Schema.Constraint.newBuilder().setId((int)id).setKind(Schema.Constraint.Kind.DATE).setDate(this.constraint.serialize()).build();
        }

        public static Either<Error.FormatError, ConstraintKind> deserialize(Schema.Constraint c) {
            long id = c.getId();
            if (!c.hasDate()) {
                Error.FormatError formatError = new Error().new Error.FormatError();
                formatError.getClass();
                return API.Left((Object)formatError.new Error.FormatError.DeserializationError("invalid Date constraint"));
            }
            Either<Error.FormatError, DateConstraint> res = DateConstraint.deserialize_enum(c.getDate());
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            return API.Right((Object)new Date((DateConstraint)res.get()));
        }
    }

    public static final class Str
    extends ConstraintKind
    implements Serializable {
        private final StrConstraint constraint;

        public boolean check(String value) {
            return this.constraint.check(value);
        }

        public Str(StrConstraint constraint) {
            this.constraint = constraint;
        }

        public String toString() {
            return this.constraint.toString();
        }

        @Override
        public Schema.Constraint serialize(long id) {
            return Schema.Constraint.newBuilder().setId((int)id).setKind(Schema.Constraint.Kind.STRING).setStr(this.constraint.serialize()).build();
        }

        public static Either<Error.FormatError, ConstraintKind> deserialize(Schema.Constraint c) {
            long id = c.getId();
            if (!c.hasStr()) {
                Error.FormatError formatError = new Error().new Error.FormatError();
                formatError.getClass();
                return API.Left((Object)formatError.new Error.FormatError.DeserializationError("invalid Str constraint"));
            }
            Either<Error.FormatError, StrConstraint> res = StrConstraint.deserialize_enum(c.getStr());
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            return API.Right((Object)new Str((StrConstraint)res.get()));
        }
    }

    public static final class Int
    extends ConstraintKind
    implements Serializable {
        private final IntConstraint constraint;

        public boolean check(long value) {
            return this.constraint.check(value);
        }

        public Int(IntConstraint constraint) {
            this.constraint = constraint;
        }

        public String toString() {
            return this.constraint.toString();
        }

        @Override
        public Schema.Constraint serialize(long id) {
            return Schema.Constraint.newBuilder().setId((int)id).setKind(Schema.Constraint.Kind.INT).setInt(this.constraint.serialize()).build();
        }

        public static Either<Error.FormatError, ConstraintKind> deserialize(Schema.Constraint c) {
            long id = c.getId();
            if (!c.hasInt()) {
                Error.FormatError formatError = new Error().new Error.FormatError();
                formatError.getClass();
                return API.Left((Object)formatError.new Error.FormatError.DeserializationError("invalid Int constraint"));
            }
            Either<Error.FormatError, IntConstraint> res = IntConstraint.deserialize_enum(c.getInt());
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            return API.Right((Object)new Int((IntConstraint)res.get()));
        }
    }
}

