/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.MatchedVariables;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.constraints.Constraint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class Combinator
implements Serializable {
    private final MatchedVariables variables;
    private final List<Predicate> predicates;
    private final List<Constraint> constraints;
    private final Set<Fact> all_facts;
    private final Set<Fact> current_facts;

    public List<Map<Long, ID>> combine() {
        ArrayList<Map<Long, ID>> variables = new ArrayList<Map<Long, ID>>();
        if (this.predicates.isEmpty()) {
            Optional<Map<Long, ID>> vars = this.variables.complete();
            if (vars.isPresent()) {
                variables.add(vars.get());
            }
            return variables;
        }
        ListIterator<Predicate> pit = this.predicates.listIterator();
        while (pit.hasNext()) {
            if (this.current_facts.isEmpty()) {
                return variables;
            }
            Predicate pred = pit.next();
            for (Fact current_fact : this.current_facts) {
                MatchedVariables vars = this.variables.clone();
                boolean match_ids = true;
                int min_size = Math.min(pred.ids().size(), current_fact.predicate().ids().size());
                for (int i = 0; i < min_size; ++i) {
                    ID id = pred.ids().get(i);
                    if (!(id instanceof ID.Variable)) continue;
                    long key = ((ID.Variable)id).value();
                    ID value = current_fact.predicate().ids().get(i);
                    for (Constraint c : this.constraints) {
                        if (c.check(key, value)) continue;
                        match_ids = false;
                        break;
                    }
                    if (!vars.insert(key, value)) {
                        match_ids = false;
                    }
                    if (!match_ids) break;
                }
                if (!match_ids) continue;
                if (pit.hasNext()) {
                    ArrayList<Predicate> next_predicates = new ArrayList<Predicate>();
                    for (int i = pit.nextIndex(); i < this.predicates.size(); ++i) {
                        next_predicates.add(this.predicates.get(i));
                    }
                    if (next_predicates.isEmpty()) continue;
                    List<Map<Long, ID>> next = new Combinator(vars, next_predicates, this.constraints, this.all_facts).combine();
                    if (next.isEmpty()) {
                        return variables;
                    }
                    variables.addAll(next);
                    continue;
                }
                Optional<Map<Long, ID>> v = vars.complete();
                if (!v.isPresent()) continue;
                variables.add(v.get());
            }
        }
        return variables;
    }

    public Combinator(MatchedVariables variables, List<Predicate> predicates, List<Constraint> constraints, Set<Fact> facts) {
        this.variables = variables;
        this.predicates = predicates;
        this.constraints = constraints;
        this.all_facts = facts;
        this.current_facts = facts.stream().filter(fact -> fact.match_predicate((Predicate)predicates.get(0))).collect(Collectors.toSet());
    }
}

