/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.SymbolTable;
import java.util.Objects;

public abstract class Atom {
    public abstract ID convert(SymbolTable var1);

    public static class Date
    extends Atom {
        long value;

        public Date(long value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Date(this.value);
        }

        public String toString() {
            return "" + this.value;
        }
    }

    public static class Bytes
    extends Atom {
        byte[] value;

        public Bytes(byte[] value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Bytes(this.value);
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }
    }

    public static class Str
    extends Atom {
        String value;

        public Str(String value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Str(this.value);
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }
    }

    public static class Integer
    extends Atom {
        long value;

        public Integer(long value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Integer(this.value);
        }

        public String toString() {
            return "" + this.value;
        }
    }

    public static class Variable
    extends Atom {
        int value;

        public Variable(int value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Variable(this.value);
        }

        public String toString() {
            return "" + this.value + "?";
        }
    }

    public static class Symbol
    extends Atom {
        String value;

        public Symbol(String value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Symbol(symbols.insert(this.value));
        }

        public String toString() {
            return "#" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Symbol symbol = (Symbol)o;
            return Objects.equals(this.value, symbol.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

