/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Caveat {
    private final List<Rule> queries;

    public Caveat(List<Rule> queries) {
        this.queries = queries;
    }

    public List<Rule> queries() {
        return this.queries;
    }

    public int hashCode() {
        return Objects.hash(this.queries);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return super.toString();
    }

    public Schema.Caveat serialize() {
        Schema.Caveat.Builder b = Schema.Caveat.newBuilder();
        for (int i = 0; i < this.queries.size(); ++i) {
            b.addQueries(this.queries.get(i).serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Caveat> deserialize(Schema.Caveat caveat) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        for (Schema.Rule query : caveat.getQueriesList()) {
            Either<Error.FormatError, Rule> res = Rule.deserialize(query);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            queries.add((Rule)res.get());
        }
        return API.Right((Object)new Caveat(queries));
    }
}

