/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCaveat;
import com.clevercloud.biscuit.error.LogicError;
import com.clevercloud.biscuit.token.Biscuit;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.builder.Atom;
import com.clevercloud.biscuit.token.builder.Caveat;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Utils;
import com.clevercloud.biscuit.token.builder.constraints.IntConstraint;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Verifier {
    Biscuit token;
    List<Caveat> caveats;
    World base_world;
    World world;
    SymbolTable base_symbols;
    SymbolTable symbols;

    private Verifier(Biscuit token, World w) {
        this.token = token;
        this.base_world = w;
        this.world = new World(this.base_world);
        this.base_symbols = new SymbolTable(this.token.symbols);
        this.symbols = new SymbolTable(this.token.symbols);
        this.caveats = new ArrayList<Caveat>();
    }

    public static Either<Error, Verifier> make(Biscuit token, Option<PublicKey> root) {
        Object res;
        if (!token.is_sealed() && (res = token.check_root_key((PublicKey)root.get())).isLeft()) {
            Error e = (Error)res.getLeft();
            return API.Left((Object)e);
        }
        res = token.generate_world();
        if (res.isLeft()) {
            Error e = (Error)res.getLeft();
            System.out.println(e);
            return API.Left((Object)e);
        }
        return API.Right((Object)new Verifier(token, (World)res.get()));
    }

    public void reset() {
        this.world = new World(this.base_world);
        this.symbols = new SymbolTable(this.base_symbols);
        this.caveats = new ArrayList<Caveat>();
    }

    public void snapshot() {
        this.base_world = new World(this.world);
        this.base_symbols = new SymbolTable(this.symbols);
    }

    public void add_fact(Fact fact) {
        this.world.add_fact(fact.convert(this.symbols));
    }

    public void add_rule(Rule rule) {
        this.world.add_rule(rule.convert(this.symbols));
    }

    public void add_caveat(Caveat caveat) {
        this.caveats.add(caveat);
        this.world.add_caveat(caveat.convert(this.symbols));
    }

    public void add_resource(String resource) {
        this.world.add_fact(Utils.fact("resource", Arrays.asList(Utils.s("ambient"), Utils.string(resource))).convert(this.symbols));
    }

    public void add_operation(String operation) {
        this.world.add_fact(Utils.fact("operation", Arrays.asList(Utils.s("ambient"), Utils.s(operation))).convert(this.symbols));
    }

    public void set_time() {
        this.world.add_fact(Utils.fact("time", Arrays.asList(Utils.s("ambient"), Utils.date(new Date()))).convert(this.symbols));
    }

    public void revocation_check(List<Long> ids) {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("revocation_check", Arrays.asList(Utils.var(0)), Arrays.asList(Utils.pred("revocation_id", Arrays.asList(Utils.var(0)))), Arrays.asList(new IntConstraint.NotInSet(0L, new HashSet<Long>(ids)))));
        this.caveats.add(new Caveat(q));
    }

    public List<String> get_revocation_ids() {
        ArrayList<String> ids = new ArrayList<String>();
        Rule getRevocationIds = Utils.rule("revocation_id", Arrays.asList(Utils.var(0)), Arrays.asList(Utils.pred("revocation_id", Arrays.asList(Utils.var(0)))));
        this.query(getRevocationIds).stream().forEach(fact -> fact.ids().stream().forEach(id -> {
            if (id instanceof Atom.Str) {
                ids.add(((Atom.Str)id).value());
            }
        }));
        return ids;
    }

    public Set<Fact> query(Rule query) {
        this.world.run();
        Set<com.clevercloud.biscuit.datalog.Fact> facts = this.world.query_rule(query.convert(this.symbols));
        HashSet<Fact> s = new HashSet<Fact>();
        for (com.clevercloud.biscuit.datalog.Fact f : facts) {
            s.add(Fact.convert_from(f, this.symbols));
        }
        return s;
    }

    public Either<Error, Void> verify() {
        Set<com.clevercloud.biscuit.datalog.Fact> res;
        int k;
        int j;
        if (this.symbols.get("authority").isEmpty() || this.symbols.get("ambient").isEmpty()) {
            return API.Left((Object)new Error().new Error.MissingSymbols());
        }
        this.world.run();
        SymbolTable symbols = new SymbolTable(this.symbols);
        ArrayList<FailedCaveat> errors = new ArrayList<FailedCaveat>();
        for (j = 0; j < this.token.authority.caveats.size(); ++j) {
            boolean successful = false;
            com.clevercloud.biscuit.datalog.Caveat c = this.token.authority.caveats.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = this.world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            FailedCaveat failedCaveat = new FailedCaveat();
            failedCaveat.getClass();
            errors.add(failedCaveat.new FailedCaveat.FailedBlock(0L, j, symbols.print_caveat(this.token.authority.caveats.get(j))));
        }
        for (j = 0; j < this.caveats.size(); ++j) {
            com.clevercloud.biscuit.datalog.Caveat c = this.caveats.get(j).convert(symbols);
            boolean successful = false;
            for (k = 0; k < c.queries().size(); ++k) {
                res = this.world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            FailedCaveat failedCaveat = new FailedCaveat();
            failedCaveat.getClass();
            errors.add(failedCaveat.new FailedCaveat.FailedVerifier(j, symbols.print_caveat(c)));
        }
        for (int i = 0; i < this.token.blocks.size(); ++i) {
            Block b = this.token.blocks.get(i);
            for (int j2 = 0; j2 < b.caveats.size(); ++j2) {
                boolean successful = false;
                com.clevercloud.biscuit.datalog.Caveat c = b.caveats.get(j2);
                for (int k2 = 0; k2 < c.queries().size(); ++k2) {
                    Set<com.clevercloud.biscuit.datalog.Fact> res2 = this.world.query_rule(c.queries().get(k2));
                    if (res2.isEmpty()) continue;
                    successful = true;
                    break;
                }
                if (successful) continue;
                FailedCaveat failedCaveat = new FailedCaveat();
                failedCaveat.getClass();
                errors.add(failedCaveat.new FailedCaveat.FailedBlock(b.index, j2, symbols.print_caveat(b.caveats.get(j2))));
            }
        }
        if (errors.isEmpty()) {
            return API.Right(null);
        }
        System.out.println(errors);
        Error error = new Error();
        error.getClass();
        LogicError logicError = new LogicError();
        logicError.getClass();
        return API.Left((Object)error.new Error.FailedLogic(logicError.new LogicError.FailedCaveats(errors)));
    }

    public String print_world() {
        return this.symbols.print_world(this.world);
    }
}

