/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.builder.Term;
import com.google.protobuf.ByteString;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.Objects;

public abstract class ID
implements Serializable {
    public abstract boolean match(ID var1);

    public abstract Schema.ID serialize();

    public static Either<Error.FormatError, ID> deserialize_enum(Schema.ID id) {
        if (id.getKind() == Schema.ID.Kind.DATE) {
            return Date.deserialize(id);
        }
        if (id.getKind() == Schema.ID.Kind.INTEGER) {
            return Integer.deserialize(id);
        }
        if (id.getKind() == Schema.ID.Kind.STR) {
            return Str.deserialize(id);
        }
        if (id.getKind() == Schema.ID.Kind.BYTES) {
            return Bytes.deserialize(id);
        }
        if (id.getKind() == Schema.ID.Kind.SYMBOL) {
            return Symbol.deserialize(id);
        }
        if (id.getKind() == Schema.ID.Kind.VARIABLE) {
            return Variable.deserialize(id);
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind"));
    }

    public abstract Term toTerm(SymbolTable var1);

    public static final class Variable
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            return true;
        }

        public Variable(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.value == variable.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value + "?";
        }

        @Override
        public Schema.ID serialize() {
            return Schema.ID.newBuilder().setKind(Schema.ID.Kind.VARIABLE).setVariable((int)this.value).build();
        }

        public static Either<Error.FormatError, ID> deserialize(Schema.ID id) {
            if (id.getKind() != Schema.ID.Kind.VARIABLE) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind"));
            }
            return API.Right((Object)new Variable(id.getVariable()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Variable(symbols.print_symbol((int)this.value));
        }
    }

    public static final class Symbol
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Symbol) {
                return this.value == ((Symbol)other).value;
            }
            return false;
        }

        public Symbol(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Symbol symbol = (Symbol)o;
            return this.value == symbol.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "#" + this.value;
        }

        @Override
        public Schema.ID serialize() {
            return Schema.ID.newBuilder().setKind(Schema.ID.Kind.SYMBOL).setSymbol(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserialize(Schema.ID id) {
            if (id.getKind() != Schema.ID.Kind.SYMBOL) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind"));
            }
            return API.Right((Object)new Symbol(id.getSymbol()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Symbol(symbols.print_symbol((int)this.value));
        }
    }

    public static final class Bytes
    extends ID
    implements Serializable {
        private final byte[] value;

        public byte[] value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Str) {
                return this.value.equals(((Bytes)other).value);
            }
            return false;
        }

        public Bytes(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bytes str = (Bytes)o;
            return Objects.equals(this.value, str.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value});
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public Schema.ID serialize() {
            return Schema.ID.newBuilder().setKind(Schema.ID.Kind.BYTES).setBytes(ByteString.copyFrom((byte[])this.value)).build();
        }

        public static Either<Error.FormatError, ID> deserialize(Schema.ID id) {
            if (id.getKind() != Schema.ID.Kind.STR) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind"));
            }
            return API.Right((Object)new Str(id.getStr()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Bytes(this.value);
        }
    }

    public static final class Str
    extends ID
    implements Serializable {
        private final String value;

        public String value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Str) {
                return this.value.equals(((Str)other).value);
            }
            return false;
        }

        public Str(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Str str = (Str)o;
            return Objects.equals(this.value, str.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value;
        }

        @Override
        public Schema.ID serialize() {
            return Schema.ID.newBuilder().setKind(Schema.ID.Kind.STR).setStr(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserialize(Schema.ID id) {
            if (id.getKind() != Schema.ID.Kind.STR) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind"));
            }
            return API.Right((Object)new Str(id.getStr()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Str(this.value);
        }
    }

    public static final class Integer
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Integer) {
                return this.value == ((Integer)other).value;
            }
            return false;
        }

        public Integer(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Integer integer = (Integer)o;
            return this.value == integer.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public Schema.ID serialize() {
            return Schema.ID.newBuilder().setKind(Schema.ID.Kind.INTEGER).setInteger(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserialize(Schema.ID id) {
            if (id.getKind() != Schema.ID.Kind.INTEGER) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind"));
            }
            return API.Right((Object)new Integer(id.getInteger()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Integer(this.value);
        }
    }

    public static final class Date
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            return other instanceof Variable;
        }

        public Date(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Date date = (Date)o;
            return this.value == date.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "@" + this.value;
        }

        @Override
        public Schema.ID serialize() {
            return Schema.ID.newBuilder().setKind(Schema.ID.Kind.DATE).setDate(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserialize(Schema.ID id) {
            if (id.getKind() != Schema.ID.Kind.DATE) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind"));
            }
            return API.Right((Object)new Date(id.getDate()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Date(this.value);
        }
    }
}

